(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsCa = factory();
  }
})(this, function () {
  var patterns =
    '{"b":[{"a":[{},[1]],"e":[{},[1]],"i":[{"s":[{"e":[{},[0,0,3]]}]},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"l":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"c":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"l":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"d":[{"a":[{},[1]],"e":[{"s":[{"a":[{"g":[{},[0,0,0,3]],"r":[{},[0,0,0,3]],"v":[{},[0,0,0,3]]}],"e":[{"n":[{"c":[{},[0,0,0,3]]}]}]}]},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[3]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"f":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"l":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"g":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"à":[{},[0,0,2]],"è":[{},[0,0,2]],"ò":[{},[0,0,2]]},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"ü":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"è":[{},[0,0,2]],"i":[{},[0,0,2]]},[1]],"l":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"n":[{"o":[{},[0,2]],"ò":[{},[0,2]]}]}],"h":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"j":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"l":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"l":[{"a":[{},[3,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[3,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"m":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"n":[{"a":[{},[1]],"e":[{"f":[{},[3]],"i":[{},[3]]},[1]],"i":[{"e":[{"t":[{"z":[{"s":[{"c":[{"h":[{"e":[{},[0,0,2,0,0,1,0,2]]}]}]}]}]}]}]},[3]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"y":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"s":[{"i":[{},[0,3]]}]}],"p":[{"a":[{},[1]],"e":[{},[3]],"i":[{},[3]],"o":[{},[3]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"l":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]},[3]],"s":[{"i":[{},[0,2]],"e":[{},[0,2]],"í":[{},[0,2]]}],"n":[{"e":[{"u":[{},[0,2]]}]}]}],"q":[{"u":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{"e":[{},[0,0,0,3]]},[0,0,2]],"o":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"à":[{},[0,0,2]],"è":[{},[0,0,2]],"ò":[{},[0,0,2]]},[1]],"ü":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"è":[{},[0,0,2]],"i":[{},[0,0,2]]},[1]]}],"r":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{"t":[{"h":[{"e":[{"r":[{"f":[{"o":[{"r":[{"d":[{},[0,0,1,2]]}]}]}]}]}]}]}]},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"s":[{"a":[{},[1]],"e":[{"r":[{},[3]],"m":[{"p":[{},[0,3]]}],"s":[{"p":[{},[0,3]]}]},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{"b":[{"a":[{},[0,0,0,3]]}]},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"t":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"i":[{},[1,2]],"o":[{},[1,2]],"u":[{},[1,2]],"é":[{},[1,2]],"í":[{},[1,2]],"ó":[{},[1,2]],"ú":[{},[1,2]],"à":[{},[1,2]],"è":[{},[1,2]],"ò":[{},[1,2]]}]}],"v":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"x":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"z":[{"a":[{},[1]],"e":[{},[1]],"i":[{},[1]],"o":[{},[1]],"u":[{},[1]],"é":[{},[1]],"í":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"è":[{},[1]],"ò":[{},[1]]}],"ç":[{"o":[{},[1]],"a":[{},[1]],"u":[{},[1]],"ó":[{},[1]],"ú":[{},[1]],"à":[{},[1]],"ò":[{},[1]]}],"a":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"s":[{"m":[{"e":[{".":[{},[0,1]]}]}],"t":[{"a":[{".":[{},[0,1]]}]}]}]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"m":[{".":[{},[0,1]]}]}],"n":[{"e":[{},[0,3]]}],"r":[{"i":[{},[0,3]]}]}],"e":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"s":[{"m":[{"e":[{".":[{},[0,1]]}]},[0,3]],"t":[{"a":[{".":[{},[0,1]]}]}]}],"n":[{"s":[{"t":[{"e":[{"i":[{"n":[{},[0,0,0,1,2]]}]}]}]}]}]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"m":[{".":[{},[0,1]]}]}],"x":[{"p":[{},[3]]}],"l":[{"e":[{},[0,3]]}],"r":[{"i":[{"o":[{},[0,3]],"s":[{},[0,3]]}]}],"s":[{"a":[{"c":[{"o":[{},[0,0,3]]}],"f":[{},[0,0,3]],"p":[{},[0,0,3]],"r":[{"r":[{},[0,0,3]]}],"s":[{},[0,0,3]]}],"i":[{"n":[{"t":[{},[0,0,3]]}]}]}]}],"i":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"s":[{"m":[{"e":[{".":[{},[0,1]]}]}],"t":[{"a":[{".":[{},[0,1]]}]}]}]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"m":[{".":[{},[0,1]]}]}],"g":[{"n":[{},[0,0,3]]}],"n":[{"e":[{"x":[{},[0,0,3]]}]}]}],"o":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"s":[{"m":[{"e":[{".":[{},[0,1]]}]}],"t":[{"a":[{".":[{},[0,1]]}]}]}]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"m":[{".":[{},[0,1]]}]}],"r":[{"o":[{},[0,3]]}],"g":[{"n":[{"ò":[{},[0,3]]}]}]}],"u":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{"t":[{},[0,0,3]]},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"s":[{"m":[{"e":[{".":[{},[0,1]]}]}],"t":[{"a":[{".":[{},[0,1]]}]}]}]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"m":[{".":[{},[0,1]]}]}]}],"é":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"í":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"ó":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"ú":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"à":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"è":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"ò":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ï":[{},[0,1]],"ü":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"ï":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"u":[{},[0,1,2]]},[0,1]],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],"ü":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]],"ó":[{},[0,1]],"ú":[{},[0,1]],"à":[{},[0,1]],"è":[{},[0,1]],"ò":[{},[0,1]],"i":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"u":[{},[0,1,2]]}],"u":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"o":[{},[0,1,2]],"é":[{},[0,1,2]],"í":[{},[0,1,2]],"ó":[{},[0,1,2]],"ú":[{},[0,1,2]],"à":[{},[0,1,2]],"è":[{},[0,1,2]],"ò":[{},[0,1,2]],"i":[{},[0,1,2]],"u":[{},[0,1,2]]}]}],".":[{"h":[{"i":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"é":[{},[0,0,2]],"ó":[{},[0,0,2]],"ú":[{},[0,0,2]],"à":[{},[0,0,2]],"è":[{},[0,0,2]],"ò":[{},[0,0,2]],"p":[{"e":[{"r":[{"m":[{"n":[{},[0,0,0,0,0,0,2]]}]},[0,0,0,0,2]]}]}]}],"u":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"à":[{},[0,0,2]],"è":[{},[0,0,2]],"ò":[{},[0,0,2]]}]}],"i":[{"è":[{},[0,2]],"ò":[{},[0,2]],"n":[{"a":[{"c":[{},[0,0,3]],"d":[{},[0,0,3]],"p":[{},[0,0,3]]}],"e":[{"s":[{},[0,0,3]]}],"o":[{},[0,0,3]],"t":[{"e":[{"r":[{},[0,0,0,0,2]]}]}]}]}],"u":[{"è":[{},[0,2]],"ò":[{},[0,2]]}],"a":[{"n":[{"t":[{"i":[{"h":[{"i":[{},[0,0,0,0,0,0,2]]}]}]}]}]}],"b":[{"e":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}]}],"c":[{"a":[{"p":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]]}],"l":[{"a":[{"r":[{},[0,0,0,2]]}]}],"o":[{"l":[{"l":[{},[0,0,2]]}],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"h":[{},[0,0,2]]}],"d":[{"e":[{"s":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}]}],"e":[{"n":[{"a":[{},[0,0,3]]}]}],"m":[{"a":[{"l":[{"t":[{"h":[{"u":[{"s":[{},[0,0,0,1,2]]}]}]}]},[0,0,2]]}]}],"p":[{"a":[{"n":[{},[0,0,2]]}],"e":[{"r":[{"i":[{},[0,0,3]]},[0,0,2]]}],"o":[{"s":[{"t":[{},[0,0,0,2]]}]}],"s":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"e":[{"b":[{"e":[{"s":[{},[0,0,0,0,2]]}]}],"d":[{},[0,0,2]]}]}],"s":[{"u":[{"b":[{"o":[{},[0,0,0,3]],"d":[{"e":[{"s":[{},[0,0,0,0,0,2]]}]}]},[0,0,2]],"p":[{"e":[{"r":[{},[0,0,0,0,2]]}]}]}]}],"t":[{"r":[{"a":[{"n":[{"s":[{},[0,0,0,0,2]]}]}]}],"h":[{},[0,0,2]]}]}]}';
  var hyphenation = [
    "cu-rie",
    "cu-ries",
    "gei-sha",
    "gei-shes",
    "goua-che",
    "goua-ches",
    "hip-py",
    "hip-pies",
    "hob-by",
    "hob-bies",
    "jeep",
    "jeeps",
    "joule",
    "joules",
    "klee-nex",
    "klee-nexs",
    "lar-ghet-ti",
    "lar-ghet-to",
    "lied",
    "lieder",
    "nos-al-tres",
    "ro-yal-ties",
    "ro-yal-ty",
    "vos-al-tres",
    "whis-ky",
    "whis-kies",
    ""
  ];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
