(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsDa = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"e":[{},[0,0,3]],"n":[{"k":[{},[0,0,3]],"s":[{},[0,0,1]]}]}],"b":[{"e":[{"l":[{"a":[{},[0,0,5]]}],"t":[{},[0,0,1]]}],"i":[{"t":[{"r":[{},[0,0,4]]}]}]}],"d":[{"e":[{"r":[{"i":[{},[0,0,0,3]]}]}],"i":[{"a":[{"g":[{"n":[{"o":[{},[0,0,0,0,0,0,5]]}]}]}]}]}],"h":[{"e":[{"r":[{},[0,0,0,3]]}],"o":[{"v":[{"e":[{"d":[{},[0,0,0,0,0,3]]}]}]}]}],"n":[{"e":[{"t":[{},[0,0,4,5]]}]}],"o":[{"m":[{},[0,0,1]],"v":[{"e":[{},[0,0,0,4]]}]}],"p":[{"o":[{},[0,0,1]]}],"t":[{"i":[{"l":[{},[0,0,0,3]]}]}],"y":[{"d":[{"r":[{},[0,0,5]]}]}],"s":[{"å":[{},[0,0,3]]}],"æ":[{"r":[{"i":[{},[0,0,5]]}]}],"ø":[{"v":[{"r":[{},[0,0,3]]}]}]}],"a":[{"b":[{"l":[{"e":[{},[0,0,5]]}],"s":[{"t":[{},[3]]}]}],"c":[{},[0,3]],"d":[{"e":[{"l":[{"a":[{},[0,0,0,5]]}]}],"g":[{},[5]]}],"e":[{},[0,1]],"f":[{"g":[{},[5]],"l":[{},[5,4,1]],"r":[{"i":[{},[0,0,4]]},[0,0,3]],"s":[{},[5]]}],"g":[{"e":[{"f":[{},[0,4]]}],"i":[{"n":[{},[0,0,5]]},[0,4]],"s":[{"i":[{},[0,0,5]]}],"t":[{"i":[{},[3]]}],"y":[{},[0,4]]}],"h":[{},[0,3]],"i":[{"s":[{"t":[{},[0,0,0,5]]}]}],"j":[{},[0,3]],"k":[{"a":[{},[0,5]],"e":[{},[0,3]],"r":[{},[0,5]],"u":[{},[0,0,0,5]]}],"l":[{"a":[{},[0,3]],"e":[{},[0,1]],"i":[{},[0,1]],"k":[{"v":[{},[4]]},[0,0,3]],"o":[{},[0,1]],"s":[{"i":[{},[0,0,5]]}],"u":[{},[0,3]],"y":[{},[0,1]]}],"m":[{"p":[{"a":[{},[0,0,4]]}]}],"n":[{"a":[{"l":[{"y":[{},[3]]}]}],"k":[{"r":[{},[0,0,4,5]]}],"u":[{},[0,3]],"v":[{},[3]]}],"o":[{},[0,5]],"p":[{"e":[{},[0,5]],"i":[{},[0,3]],"o":[{},[0,5]]}],"r":[{"a":[{"f":[{},[0,0,5]]},[0,1]],"b":[{},[1]],"e":[{},[0,1]],"g":[{},[5]],"i":[{},[0,1]],"o":[{},[0,3]]}],"s":[{"a":[{},[0,3]],"c":[{},[0,3]],"i":[{},[0,1]],"k":[{},[0,3]],"o":[{},[0,3]],"p":[{},[3,3]],"t":[{"e":[{},[0,3]],"i":[{},[0,3]]}]}],"t":[{"a":[{},[0,1,0,1]],"e":[{},[0,1]],"i":[{"n":[{},[0,4,5]]},[0,1]],"o":[{"v":[{},[0,0,0,5]]},[0,1]],"r":[{},[0,5]],"u":[{},[0,1]],"ø":[{},[0,3]]}],"v":[{"a":[{},[0,5]],"e":[{},[0,1]],"æ":[{},[0,5]]}],"z":[{},[0,5]]}],"b":[{"a":[{"t":[{"i":[{},[0,0,4]]}]},[1]],"d":[{},[4]],"e":[{"k":[{},[0,0,1]],"r":[{"o":[{},[0,0,3]],"u":[{},[0,0,5]]}],"s":[{},[0,0,1,4]],"t":[{"r":[{},[0,0,1]]}]},[1]],"i":[{"s":[{"k":[{},[0,0,5]]}]},[1]],"j":[{},[0,1]],"n":[{},[4,1]],"o":[{"g":[{"r":[{},[0,0,4]]}],"r":[{"a":[{},[0,0,3]],"e":[{},[0,0,5]]}]},[1]],"r":[{"ø":[{"d":[{},[0,0,0,0,3]]}]},[1,0,4]],"s":[{"k":[{},[0,0,5]],"o":[{},[0,3]],"t":[{},[0,1]]},[4]],"t":[{},[0,5]],"u":[{"s":[{"t":[{"r":[{},[0,0,4,5]]}]}]},[3]],"w":[{},[0,5]],"y":[{"s":[{},[0,0,5]]},[1]],"æ":[{},[5]]}],"c":[{"c":[{},[4,1]],"e":[{"r":[{"o":[{},[0,0,5]]}]},[1]],"h":[{".":[{},[4]]},[3]],"i":[{"o":[{},[0,0,4]]}],"k":[{},[0,0,3]],"y":[{},[5]]}],"d":[{"a":[{"f":[{},[4,3]],"n":[{"t":[{"a":[{},[0,5]]}]}],"s":[{},[0,0,4]]},[3]],"b":[{},[0,1]],"d":[{},[0,1,4]],"e":[{"d":[{},[0,0,5]],"l":[{"e":[{"m":[{},[4,0,4]]}]}],"r":[{"e":[{"r":[{"i":[{},[0,0,0,5]]}]}],"i":[{"g":[{},[0,0,4]]}]}],"s":[{"k":[{},[0,0,5]]}]},[1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,3]],"i":[{"e":[{},[0,0,1]],"l":[{},[0,0,5]]},[1]],"j":[{},[0,3]],"k":[{},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[4,1]],"o":[{"p":[{},[4]],"v":[{},[0,5]]},[3]],"p":[{},[0,1]],"r":[{"e":[{"t":[{"t":[{},[4]]}],"v":[{"e":[{},[5,4]]}]}],"i":[{"f":[{},[3]],"v":[{},[3]]}],"o":[{"s":[{},[0,5]]}],"u":[{},[0,5]],"ø":[{"v":[{},[5]]}]}],"s":[{"a":[{"n":[{},[0,0,5]]}],"i":[{"n":[{},[0,0,5]]}],"k":[{"i":[{},[0,1]]}],"m":[{},[0,4]],"u":[{"l":[{},[0,0,0,5]]},[0,4]],"v":[{"i":[{},[0,0,5]]}],"t":[{"å":[{},[0,0,0,0,4]]}]}],"t":[{"a":[{},[0,3]],"e":[{},[0,1]],"o":[{},[0,0,5]],"r":[{},[0,5]],"u":[{},[0,0,5]]}],"u":[{"b":[{},[0,0,0,5]]},[1]],"v":[{},[0,1]],"y":[{},[3]],"æ":[{},[3]],"ø":[{},[3]]}],"e":[{"a":[{"d":[{},[0,5]],"f":[{},[0,3]],"g":[{},[0,5]],"k":[{},[0,3]],"l":[{"a":[{},[0,0,4]]},[0,1]],"n":[{},[0,3]],"p":[{},[0,5]],"t":[{},[0,3]]}],"b":[{"l":[{},[0,3]],"s":[{},[0,0,0,3]]}],"c":[{"i":[{},[0,1]]}],"d":[{"a":[{"r":[{},[0,0,5]]}],"d":[{"e":[{"l":[{},[0,0,0,0,0,5]]},[0,0,0,0,4]]}],"o":[{},[0,4]],"r":[{"a":[{},[0,0,5]],"e":[{},[0,0,3]],"i":[{"n":[{},[0,0,3]]}]}],"s":[{"t":[{"r":[{},[0,0,4]]}]}]}],"e":[{},[0,3]],"f":[{"f":[{},[3]],"r":[{},[0,3]],"t":[{},[3]]}],"g":[{"u":[{},[0,3]]}],"h":[{},[0,1]],"i":[{"n":[{},[0,3]],"s":[{},[0,0,5]]}],"j":[{"e":[{"l":[{},[0,4,5]]},[0,3]]}],"k":[{"a":[{},[0,1]],"e":[{},[0,3]],"l":[{},[0,3]],"o":[{},[4,1]],"r":[{},[0,5]],"s":[{"a":[{},[0,0,5]],"e":[{"m":[{},[3]]}],"p":[{},[3]]}],"u":[{},[0,3]],"v":[{},[0,1]],"y":[{},[0,5]]}],"l":[{"a":[{"d":[{},[0,3]],"k":[{},[0,0,3]],"r":[{},[0,0,3]],"s":[{},[0,1]]}],"e":[{"k":[{},[0,4]],"m":[{},[3]]},[0,3]],"i":[{"m":[{},[5]]},[0,1]],"o":[{},[0,3]],"s":[{"a":[{},[0,0,5]]}],"u":[{},[0,5]],"y":[{},[0,3]],"æ":[{},[0,3]],"ø":[{},[0,3]]}],"m":[{"a":[{"d":[{},[0,4]]}],"p":[{"l":[{"e":[{},[0,0,4,5]]}]}],"s":[{},[0,0,1]]}],"n":[{"a":[{"k":[{},[0,0,5]],"n":[{},[0,4]]}],"n":[{},[4]],"o":[{},[0,4]],"s":[{"o":[{},[0,0,3]]}],"u":[{},[0,5]]}],"o":[{"l":[{},[0,5]],"p":[{},[0,3]],"r":[{},[0,1]],"v":[{},[0,3]]}],"p":[{"i":[{},[0,0,0,3]],"r":[{},[0,1]]}],"r":[{"a":[{"f":[{},[0,0,3]],"g":[{},[0,4]],"k":[{},[0,4]]},[0,3]],"e":[{"f":[{},[0,4]],"g":[{"e":[{},[0,0,5]]}]},[0,1]],"h":[{"v":[{},[5]]}],"i":[{"b":[{},[0,4]]},[0,1]],"k":[{},[0,0,1]],"o":[{"d":[{},[0,0,0,5]],"v":[{},[0,0,5]]}],"s":[{},[0,0,3]],"t":[{"r":[{},[0,0,5]]}],"u":[{"m":[{},[0,3]],"n":[{},[0,0,5]]}],"y":[{},[0,5]],"ø":[{"n":[{},[0,0,5]]},[0,3]]}],"t":[{"a":[{},[0,1]],"e":[{"k":[{"s":[{},[0,0,0,0,4]]}]},[0,1]],"i":[{},[0,1]],"j":[{},[0,3]],"o":[{},[0,1]],"r":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,1]],"æ":[{},[0,5]],"ø":[{},[0,5]]}],"u":[{"m":[{},[0,3]],"n":[{},[0,3]],"r":[{},[3]]}],"v":[{"a":[{},[0,1]],"e":[{"r":[{"f":[{},[0,4,3]]}]},[0,3]],"i":[{},[0,1]],"æ":[{},[0,1]]}],"x":[{},[0,5]],"æ":[{},[0,3]],"å":[{},[0,5]]}],"f":[{"a":[{"c":[{"e":[{},[0,0,4]]}],"g":[{"s":[{},[0,0,0,0,3]]}]},[1]],"b":[{},[0,1]],"d":[{},[0,1]],"e":[{"j":[{"l":[{},[0,0,0,0,1]]},[0,0,0,4]]},[1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[1]],"k":[{},[0,1]],"l":[{},[3]],"o":[{"r":[{"e":[{"n":[{},[0,0,0,1]]}],"i":[{},[0,0,4]]}]},[1]],"p":[{},[0,1]],"s":[{},[0,1,4]],"t":[{"a":[{},[0,3]],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,5]],"v":[{"i":[{},[0,5]]}]},[4]],"u":[{},[1]],"v":[{},[0,1]],"y":[{},[3]],"æ":[{},[3]],"ø":[{"r":[{"e":[{"n":[{},[0,0,4,5]]}]}]},[3]]}],"g":[{"a":[{"r":[{"t":[{},[0,3]]}]},[1]],"b":[{},[0,1]],"d":[{},[0,1]],"e":[{"n":[{"d":[{"e":[{"n":[{},[4,5]]}]}]}],"r":[{"i":[{"n":[{},[0,0,0,3]]}]}],"s":[{},[0,0,3]]},[1]],"f":[{},[0,3]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{"b":[{},[0,0,4]],"s":[{"t":[{},[0,0,3]]}],"ø":[{},[0,0,0,4]]},[1]],"j":[{},[5]],"k":[{},[0,3]],"l":[{},[0,1]],"m":[{},[0,1]],"o":[{"m":[{},[4,5]],"v":[{},[0,5]]},[3]],"p":[{},[0,3]],"r":[{},[1]],"s":[{"a":[{},[0,0,1]],"d":[{"e":[{"l":[{"e":[{"n":[{},[0,0,0,0,4]]}]}]}]}],"e":[{},[0,4]],"h":[{"a":[{},[0,0,0,0,4]]}],"l":[{"a":[{},[0,5]]}],"o":[{"r":[{},[0,0,3]]}],"p":[{},[0,0,1]],"t":[{"i":[{"d":[{"e":[{},[0,5,4]]}]}],"r":[{},[0,4]]}],"v":[{},[0,0,1]],"ø":[{},[0,4]],"å":[{},[0,5]]}],"t":[{"a":[{},[0,3]],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,5]],"r":[{},[0,3]],"s":[{},[0,0,4]]}],"u":[{"d":[{},[0,3]],"n":[{},[0,0,0,5]]}],"v":[{},[0,3]],"y":[{"d":[{},[0,5]]},[1]],"æ":[{},[3]],"ø":[{},[3,0,1]],"å":[{},[3]]}],"h":[{"a":[{".":[{},[4]]}],"e":[{"d":[{"s":[{},[0,0,0,0,3]]}],"s":[{},[0,0,5]],"t":[{},[4]]}],"i":[{"e":[{},[0,0,4]],"n":[{},[0,0,4,5]],"s":[{},[0,0,3]]}],"o":[{"k":[{"o":[{},[0,0,5]]}],"v":[{"e":[{},[0,0,5]]}]}],"t":[{},[4,3]],"u":[{"n":[{"d":[{},[0,0,0,0,3]]},[0,0,0,4]]}],"v":[{"o":[{},[0,0,0,4]]}]}],"i":[{"a":[{},[0,1]],"b":[{"l":[{"e":[{},[0,4]]}]},[0,3]],"c":[{},[0,1]],"d":[{"r":[{},[0,3]],"s":[{"k":[{},[0,0,0,5]]}]}],"e":[{"l":[{},[0,1]],"n":[{},[0,1]],"r":[{},[0,3]],"t":[{".":[{},[0,3]]}]}],"f":[{"r":[{},[0,0,3]]}],"g":[{"u":[{},[0,3]]}],"h":[{},[0,3]],"i":[{},[0,5]],"j":[{},[0,5]],"k":[{"a":[{},[0,1]],"e":[{},[0,1]],"l":[{},[0,0,1]],"o":[{},[0,5]],"r":[{"e":[{},[0,0,3]],"i":[{},[0,0,5]]}],"s":[{"t":[{},[0,0,0,5]]}],"t":[{"u":[{},[0,0,4]]}],"u":[{},[0,3]],"v":[{},[0,0,3]]}],"l":[{"a":[{"g":[{},[0,3]]}],"e":[{"g":[{},[0,0,3]],"j":[{},[0,0,5]],"l":[{},[0,0,5]]}],"i":[{"d":[{},[0,4,5]]},[0,3]],"k":[{},[0,0,3]],"o":[{},[0,1]],"u":[{},[0,0,5]]}],"m":[{"u":[{},[0,3]]}],"n":[{"d":[{"t":[{},[0,0,0,3]]}],"f":[{},[5]],"g":[{"s":[{},[0,0,0,0,1]]}],"s":[{"v":[{},[0,0,4]]},[0,0,3]],"t":[{"e":[{"r":[{},[0,0,0,0,0,1]]}]}],"u":[{},[0,3]]}],"o":[{"d":[{},[0,3]],"g":[{},[0,3]],"k":[{},[0,5]],"l":[{},[0,3]],"n":[{"s":[{},[0,0,0,0,1]]},[0,0,0,4]],"r":[{},[0,5,5]],"t":[{},[0,3]]}],"p":[{"i":[{},[0,5]],"l":[{"i":[{},[0,3]]}],"r":[{},[0,5]]}],"r":[{"e":[{},[0,3]],"i":[{},[0,3]],"t":[{},[0,0,5]]}],"s":[{"c":[{},[0,3]],"i":[{},[0,3]],"m":[{},[0,4]],"p":[{},[0,0,3]],"t":[{"e":[{"r":[{},[0,1]]}],"i":[{},[0,3]]}],"u":[{"a":[{},[0,5]]}]}],"t":[{"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,3]],"r":[{"e":[{".":[{},[0,0,5]]}]},[0,3]],"u":[{},[0,1]],"y":[{},[0,3]],"æ":[{},[0,5]]}],"u":[{},[0,1]],"v":[{"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]]}],"ø":[{},[0,3]]}],"j":[{"a":[{"g":[{},[0,3]]}],"d":[{"e":[{"r":[{"e":[{"r":[{},[0,0,0,4]]}]}]}],"s":[{},[0,0,0,1]]}],"e":[{"k":[{"t":[{"o":[{},[0,0,0,4]]}]}],"n":[{".":[{},[4,5]]}]}],"k":[{},[0,5]],"l":[{"e":[{},[0,3]],"i":[{},[0,3]],"m":[{"e":[{"l":[{"d":[{"i":[{},[0,0,0,0,0,4]]},[0,0,0,0,0,0,5]]}]}]}]}],"r":[{"e":[{},[0,0,0,5]]},[0,3]],"u":[{"s":[{},[0,0,3]]}]}],"k":[{"a":[{"p":[{},[5]],"u":[{},[0,5]],"v":[{},[5]]}],"b":[{},[0,5]],"e":[{"l":[{"s":[{},[0,0,0,5]]}],"s":[{"k":[{},[0,0,3]],"t":[{},[0,0,5]]}],"t":[{"a":[{},[0,0,4,5]]}]}],"h":[{},[0,3]],"i":[{"e":[{},[0,0,3]],"s":[{"t":[{},[0,0,3]]}]}],"k":[{},[0,1]],"l":[{"a":[{"k":[{},[0,5]]}],"e":[{},[0,1]],"u":[{},[3]]}],"n":[{"y":[{},[0,4]]}],"o":[{"d":[{},[5]],"n":[{},[1]],"r":[{"a":[{},[0,0,3]],"t":[{},[3]]}],"v":[{},[0,0,3]]}],"r":[{"a":[{},[1]],"y":[{},[5]]}],"s":[{"a":[{"n":[{},[0,0,3]]}],"i":[{},[0,1]],"k":[{},[0,0,3]],"p":[{},[0,0,1]],"t":[{"e":[{},[0,3]],"u":[{},[0,5]]}],"v":[{},[0,0,5]]}],"t":[{"a":[{"r":[{},[0,4]]}],"e":[{"r":[{"h":[{},[0,4]]}]}],"i":[{"e":[{},[0,0,0,4]]}],"r":[{"e":[{},[0,0,5]]}],"s":[{},[0,0,5]]},[0,1]],"u":[{"r":[{},[3]],"s":[{},[1]],"t":[{},[3]]}],"v":[{"o":[{},[0,4]],"u":[{},[0,4]]}],"ø":[{},[3]],"å":[{},[3]]}],"l":[{"a":[{"b":[{},[5]],"d":[{"r":[{},[0,0,0,3]]}],"g":[{"d":[{},[5]],"r":[{},[0,0,4,3]]}],"m":[{},[5]],"t":[{},[1]]}],"b":[{},[0,1]],"d":[{"i":[{"a":[{"g":[{"n":[{"o":[{"s":[{},[0,0,0,0,0,0,0,0,5]]}]}]}]}]}],"r":[{},[0,3]],"s":[{"t":[{},[0,0,3]]}]}],"e":[{".":[{},[1]],"d":[{},[5]],"l":[{"e":[{},[4]]}],"m":[{"o":[{},[0,0,4]]}],"n":[{},[3]],"r":[{},[1]],"s":[{},[1]],"u":[{},[4]]}],"f":[{"i":[{"n":[{"d":[{},[0,0,0,0,0,5]]},[0,0,0,0,4]]}]},[0,1]],"g":[{"o":[{},[0,1,0,1]]}],"h":[{},[0,3]],"i":[{"g":[{"a":[{},[0,0,4]]}],"n":[{"s":[{},[4,5]],"t":[{},[4,3]],"g":[{"e":[{"n":[{"i":[{"ø":[{},[0,0,0,0,0,0,0,0,4]]}]}]}]}]}],"o":[{},[0,0,5]]}],"j":[{},[0,3]],"k":[{"e":[{},[0,1]],"o":[{},[0,1]],"y":[{},[0,3]]}],"l":[{},[0,1]],"m":[{"u":[{},[0,5]]}],"o":[{"d":[{"u":[{},[0,0,4]]}],"p":[{},[0,3]],"r":[{},[4,5]],"v":[{},[3]]}],"p":[{"s":[{},[0,4]]},[4,3]],"r":[{},[0,3]],"s":[{"e":[{"s":[{},[0,0,0,0,1]]}],"i":[{"n":[{},[0,0,5]]}],"j":[{},[0,5]]},[4]],"t":[{"a":[{"f":[{},[0,4]]},[0,1]],"e":[{"r":[{"f":[{},[0,4,5]]}]},[0,1]],"i":[{},[0,3]],"o":[{},[0,0,3]],"r":[{},[0,3]],"u":[{},[0,3]]}],"u":[{"l":[{},[0,0,5]]}],"v":[{"e":[{},[0,3]],"i":[{},[0,3]],"æ":[{},[0,3]]}],"ø":[{"s":[{},[5]]}]}],"m":[{"a":[{},[1]],"b":[{},[0,1]],"d":[{},[0,3]],"e":[{"j":[{},[4,5]]},[1]],"f":[{},[0,3]],"g":[{},[0,1]],"h":[{},[0,3]],"i":[{"k":[{},[0,0,3]],"n":[{"g":[{},[0,5]]}],"o":[{},[0,0,4]],"s":[{"t":[{"y":[{},[0,0,5]]}]}]},[1]],"k":[{},[0,3]],"l":[{},[0,1]],"m":[{"e":[{"n":[{},[0,0,0,0,5]]}]},[0,1]],"n":[{},[0,1]],"o":[{"d":[{"a":[{},[0,0,4]]}],"p":[{},[4]],"v":[{},[4,5]]},[3]],"p":[{"e":[{},[0,1]],"i":[{},[0,3]],"l":[{},[0,3]],"o":[{},[0,1]],"r":[{},[0,3]]}],"r":[{},[0,1]],"s":[{"e":[{"s":[{},[0,0,0,5]]}],"i":[{"n":[{},[0,0,5]]}],"k":[{},[0,5]],"p":[{},[0,0,3]],"t":[{"e":[{},[0,3]]}],"v":[{},[0,0,5]]}],"t":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"r":[{},[0,3]],"å":[{},[0,5]]}],"u":[{"d":[{},[0,1]],"l":[{"i":[{},[0,0,1]]},[1]]}],"y":[{},[3]],"æ":[{},[1]],"ø":[{},[3]],"å":[{},[3]]}],"n":[{"a":[{"k":[{},[4]],"l":[{},[1]]},[3]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{"r":[{},[0,3]],"s":[{"i":[{},[0,0,5]],"k":[{},[0,0,5]],"p":[{},[0,0,5]]}]},[4]],"e":[{"a":[{},[0,0,5]],"d":[{"a":[{},[0,0,4]]}],"m":[{"e":[{"n":[{"t":[{"e":[{},[0,0,0,0,0,0,5]]}]},[0,0,0,0,0,4]]}]}],"o":[{},[0,0,0,4]],"r":[{"k":[{},[0,3]],"l":[{},[0,5]]}],"s":[{"l":[{},[0,0,5]],"t":[{},[0,0,5]]}]},[1]],"f":[{},[0,1]],"g":[{"o":[{},[0,4]]}],"h":[{},[4,1]],"i":[{"m":[{},[4]],"o":[{},[0,0,5]],"s":[{"t":[{},[0,0,3]]}]},[1]],"k":[{"e":[{},[0,1]],"o":[{},[0,1]],"r":[{},[0,3]],"u":[{},[0,3]],"v":[{},[0,5]],"æ":[{},[0,3]]}],"l":[{},[4,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{"r":[{"d":[{},[0,3]]}]},[1]],"p":[{},[0,5]],"r":[{},[0,3]],"s":[{"i":[{},[0,3]],"k":[{"u":[{},[0,1]]}],"p":[{"o":[{},[0,0,3]]}],"t":[{"a":[{},[0,1]],"i":[{},[0,5]]}]},[4]],"t":[{"a":[{"l":[{"e":[{},[0,0,0,4]]}]},[0,1]],"e":[{},[0,1]],"i":[{"a":[{"l":[{"i":[{},[0,0,0,0,0,0,4]]}]}]},[0,1]],"o":[{},[0,3]],"r":[{},[0,1]],"s":[{"t":[{},[0,0,4,5]],"u":[{},[0,0,4]]}],"u":[{},[0,3]],"y":[{},[0,3]],"æ":[{},[0,5]]}],"v":[{},[4,1]],"y":[{},[3]],"z":[{},[0,3]],"æ":[{"b":[{},[4,5]]},[3]],"ø":[{},[5]]}],"o":[{"a":[{"s":[{},[0,4]]},[0,3]],"b":[{"l":[{"i":[{},[0,0,3]]}]}],"c":[{},[0,1]],"d":[{"i":[{"n":[{},[0,4]]}],"r":[{"i":[{},[0,0,5]]}],"s":[{},[0,0,5]],"u":[{"n":[{},[0,0,5]]}]}],"e":[{},[0,1]],"f":[{"r":[{},[0,0,5]]}],"g":[{"e":[{"k":[{},[0,4]],"l":[{},[0,4]]}],"o":[{},[0,4,5]],"r":[{"e":[{},[0,0,5]]}],"s":[{"k":[{},[0,0,5]]}]}],"h":[{},[0,5]],"i":[{"n":[{},[0,5]],"s":[{"e":[{},[0,0,6,5]]}]}],"j":[{},[0,1]],"k":[{"a":[{},[0,3]],"e":[{},[0,1]],"u":[{},[0,3]]}],"l":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,3]],"y":[{},[0,5]],"æ":[{},[0,5]]}],"m":[{"r":[{},[1]]}],"n":[{"k":[{},[0,0,3]]}],"o":[{"k":[{},[0,0,0,5]],"r":[{},[0,3]],"v":[{},[0,5]]}],"p":[{"i":[{},[0,3]],"l":[{},[0,0,3]],"r":[{},[0,0,3]],"s":[{},[0,0,3]],"t":[{"a":[{},[3]]}]}],"r":[{".":[{},[4]],"a":[{"n":[{},[0,0,1]]}],"d":[{"n":[{},[3]],"s":[{},[0,0,0,5]]}],"e":[{".":[{},[0,3]],"g":[{},[0,3]],"k":[{},[0,3]],"r":[{},[0,3]],"s":[{},[0,3,0,3]],"t":[{},[0,3]]}],"i":[{"e":[{"n":[{"t":[{},[3]]}]}],"m":[{},[0,0,5]],"n":[{},[0,4,5]]},[0,3]],"k":[{},[0,0,3]],"o":[{},[0,0,5]],"s":[{"l":[{},[0,0,3]],"t":[{},[0,0,3]]}],"ø":[{},[0,0,3]]}],"s":[{"i":[{},[0,3]],"o":[{},[0,3]]}],"t":[{"e":[{},[0,1]]},[0,3]],"u":[{"n":[{},[0,5]]}],"v":[{"s":[{},[0,0,4]]}],"å":[{},[0,5]]}],"p":[{"a":[{"g":[{"h":[{},[0,0,5]]}],"n":[{"l":[{},[0,5]]}]},[3]],"d":[{},[0,3]],"e":[{"c":[{},[4]],"n":[{},[3]],"r":[{"a":[{},[0,0,1]]},[1]],"s":[{},[0,0,5]],"u":[{},[0,0,3]]}],"f":[{},[0,3]],"h":[{},[4,5]],"l":[{"a":[{"n":[{},[0,4]]},[1]],"e":[{".":[{},[4]],"r":[{},[4]],"s":[{},[4]]}]}],"m":[{},[0,3]],"n":[{},[0,3]],"o":[{"k":[{},[5]],"r":[{"e":[{},[4,0,3]]}],"t":[{},[3]]}],"p":[{},[4,5,4]],"r":[{"o":[{"c":[{},[1]]},[0,4]],"æ":[{},[5]]}],"s":[{"k":[{},[0,3]],"o":[{},[0,5]],"p":[{},[0,0,4]],"t":[{},[0,3]]}],"t":[{},[0,1]],"u":[{"b":[{},[0,0,5]],"l":[{"e":[{},[0,5]]}]},[1]],"v":[{},[0,5]],"y":[{},[5,0,3]],"æ":[{"d":[{},[5]]}],"å":[{},[0,0,3]]}],"q":[{"u":[{},[0,0,4]]}],"r":[{"a":[{"f":[{},[4]],"i":[{"s":[{},[0,0,5]]}],"r":[{"b":[{},[4]]}]}],"b":[{},[0,1]],"d":[{"a":[{"r":[{},[0,4,5]]}],"r":[{},[0,3]],"s":[{},[0,0,4,3]]}],"e":[{"k":[{"s":[{},[4]]}],"l":[{"a":[{},[0,0,5]]},[1]],"n":[{"s":[{"s":[{},[0,5]]}]}],"s":[{"e":[{},[5]],"p":[{"o":[{},[0,0,5]]}],"s":[{},[4]],"t":[{},[0,0,3]],"u":[{},[0,0,5,4]]}],"t":[{"t":[{},[5]]}]}],"f":[{},[0,1]],"g":[{"u":[{},[0,1]]}],"h":[{},[0,1]],"i":[{"e":[{},[0,0,1]],"l":[{"a":[{},[0,0,5]]}],"m":[{"o":[{},[4]]}],"n":[{"g":[{"s":[{"e":[{},[0,0,0,0,0,0,4]],"o":[{"r":[{},[0,0,0,0,0,0,4]]}]}]},[0,4]],"p":[{},[4]],"t":[{},[4]]}]}],"k":[{"a":[{},[0,3]],"e":[{},[0,1]],"i":[{},[0,1]],"s":[{"o":[{},[0,0,3]]}],"u":[{},[0,3]],"æ":[{},[0,5]]}],"l":[{},[0,1]],"m":[{"o":[{},[0,0,0,4]],"u":[{},[0,5]]}],"n":[{},[0,1]],"o":[{"b":[{},[0,0,1]],"p":[{},[0,0,3]],"r":[{},[0,3]]}],"p":[{},[0,3]],"r":[{"e":[{"s":[{},[0,0,0,5]]}],"o":[{"n":[{},[0,0,0,4,5]]}]},[0,1]],"s":[{"a":[{},[0,1]],"i":[{},[0,1]],"k":[{"r":[{},[0,5]],"v":[{},[0,4,0,5]]}],"n":[{},[0,0,4]],"p":[{},[0,3]],"t":[{"u":[{},[0,5]]}],"u":[{},[0,5]],"v":[{},[0,3]]}],"t":[{"a":[{"l":[{},[0,5]]}],"e":[{"l":[{"i":[{},[0,4]]}]},[0,1]],"i":[{},[0,1]],"o":[{"r":[{},[0,4,5]]},[0,3]],"r":[{"a":[{"t":[{},[0,0,5]]}],"e":[{},[0,0,3]],"i":[{},[0,5]],"o":[{},[0,5]]}],"s":[{},[0,0,3]],"y":[{},[0,5]],"æ":[{},[0,5]],"ø":[{},[0,5]]}],"u":[{"d":[{},[0,3]],"n":[{"d":[{"a":[{},[0,0,0,4]]}]}],"t":[{},[5]]}],"v":[{"a":[{},[0,3]],"e":[{},[0,1]],"i":[{},[0,3]],"æ":[{},[0,3]]}],"y":[{"s":[{},[0,0,4]]}],"æ":[{"l":[{},[0,5]]}],"ø":[{"n":[{},[4]],"r":[{},[5]]}],"å":[{"d":[{},[3]],"r":[{},[0,5]]}]}],"s":[{"a":[{"f":[{},[0,3]],"m":[{"a":[{},[0,0,4]]},[1]],"p":[{},[0,3]],"r":[{},[0,1]],"t":[{},[1]]}],"b":[{},[4,1]],"d":[{"y":[{},[0,0,0,4]]},[0,1]],"e":[{"d":[{},[0,4]],"r":[{},[5,4]],"s":[{"e":[{},[0,0,4]]}]},[1]],"f":[{},[0,1]],"g":[{},[4,1,4]],"h":[{},[4,3]],"i":[{"b":[{"l":[{},[0,0,4]]}],"g":[{},[1]],"n":[{"t":[{},[0,5]]}],"s":[{},[5]],"t":[{},[5]],"u":[{},[5]]}],"j":[{"u":[{},[0,5]]}],"k":[{".":[{},[4]],"a":[{"b":[{},[1]]}],"e":[{},[1]],"l":[{},[0,3]],"s":[{},[0,0,5,4]],"y":[{},[5]],"å":[{},[0,4]]}],"l":[{"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,0,0,3]],"u":[{},[5]],"y":[{},[0,5]],"å":[{},[3]]}],"m":[{"y":[{},[0,4]]},[0,1]],"n":[{"i":[{"n":[{},[4]],"t":[{},[0,4]]}],"æ":[{},[0,4]]}],"o":[{"k":[{},[0,0,5]],"l":[{},[5]],"m":[{".":[{},[5]],"m":[{},[3]],"s":[{},[0,5]],"t":[{},[5]]}],"n":[{},[3]],"p":[{},[4,1]]}],"p":[{"e":[{"c":[{},[3]],"r":[{},[4]]}],"i":[{},[3,4]],"l":[{},[0,1]],"r":[{"o":[{"g":[{".":[{},[3]]}]}]}]},[0,0,4]],"r":[{},[0,5,4]],"s":[{},[0,1,4]],"t":[{".":[{},[4]],"a":[{"m":[{},[5,4]],"n":[{},[1]],"s":[{},[0,0,5]],"t":[{},[3]],"v":[{},[1]]}],"e":[{".":[{},[1]],"d":[{},[1]],"l":[{},[3]],"m":[{"o":[{},[5]]}],"n":[{},[1]],"p":[{},[5]],"r":[{".":[{},[3]]}],"s":[{},[3]],"t":[{},[5]]}],"j":[{},[5]],"o":[{"m":[{},[0,0,5]]},[3]],"r":[{},[1]],"ø":[{},[5]],"å":[{},[1]]}],"u":[{"d":[{},[0,1]],"l":[{},[3]],"n":[{},[0,3]],"r":[{},[3]]}],"v":[{"e":[{},[0,3]]}],"y":[{"s":[{},[1,0,1]]},[3,4]],"æ":[{"n":[{},[4,5]]},[1]],"ø":[{"k":[{},[0,5]]},[1]],"å":[{"r":[{},[0,0,4,5]]}]}],"t":[{"a":[{".":[{},[5]],"g":[{},[1]],"n":[{"d":[{"s":[{},[0,0,0,0,0,3]]}],"v":[{},[4]]}]}],"b":[{},[4]],"e":[{"d":[{"e":[{"l":[{},[0,0,0,0,4]]}],"s":[{},[0,0,0,0,5]]}],"g":[{},[3]],"k":[{"n":[{},[5]]}],"o":[{},[0,0,0,1]],"r":[{"m":[{},[5]],"o":[{},[0,0,5]]}]}],"f":[{},[4,1]],"g":[{},[6,3]],"h":[{},[0,1]],"i":[{"a":[{"l":[{"i":[{"s":[{"t":[{},[0,0,0,0,0,0,5]]}]}]}]}],"d":[{},[3]],"e":[{"n":[{},[0,0,4]]}],"s":[{"t":[{},[0,0,3]]}],"ø":[{},[0,0,4]]}],"k":[{},[4,3]],"l":[{"i":[{"s":[{},[0,0,0,4,5]]}]},[4,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{"r":[{"a":[{},[0,0,5]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{},[0,0,0,4]]}]}],"p":[{},[4,3]],"r":[{"a":[{},[0,4]],"e":[{"s":[{},[4]]}],"o":[{"v":[{},[0,0,0,5]]}],"y":[{},[1]],"æ":[{"k":[{".":[{},[3]]}]}]}],"s":[{"i":[{},[0,3]],"p":[{"a":[{},[0,0,4]],"r":[{},[0,0,5]]}],"t":[{},[0,3]],"u":[{"l":[{},[0,0,5]]}],"ø":[{},[0,4]],"å":[{},[0,5]]},[4]],"t":[{},[4,1]],"u":[{"d":[{"s":[{},[0,5]]}],"r":[{},[5]]}],"v":[{"e":[{},[0,5]],"æ":[{},[0,3]]}],"y":[{"p":[{},[1]]}]}],"u":[{"a":[{},[0,1]],"d":[{"l":[{},[5]],"r":[{},[0,0,5]],"s":[{},[0,0,3]],"v":[{},[3]]}],"e":[{"t":[{},[0,0,4,5]]},[0,1]],"g":[{"e":[{"r":[{"i":[{},[0,0,0,4]]}]}],"s":[{},[0,0,0,3]],"u":[{},[0,5]]}],"i":[{},[0,3]],"k":[{"l":[{},[0,5]],"t":[{"a":[{},[0,0,4]],"r":[{},[0,0,4]]}]}],"l":[{"a":[{},[0,1]],"e":[{},[0,1]],"y":[{},[0,5]],"æ":[{},[0,3]]}],"p":[{"e":[{},[0,5]],"l":[{},[0,0,5]]}],"q":[{},[0,5]],"r":[{"a":[{},[0,3]],"e":[{"g":[{},[0,4,3]],"r":[{},[0,1]]},[0,3]],"o":[{},[0,3]]}],"s":[{"a":[{},[0,0,5]],"i":[{},[0,3]],"k":[{"a":[{},[0,5]]}],"o":[{},[0,5]],"v":[{},[0,0,5]]}],"t":[{"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"r":[{},[0,0,5]],"s":[{},[0,0,5,4]]}],"v":[{},[5,5]]}],"v":[{"a":[{"d":[{},[0,0,5]],"r":[{"m":[{},[3]]}]}],"e":[{"d":[{},[1]],"l":[{"e":[{},[0,0,4,5]]}],"r":[{"e":[{"g":[{},[0,0,4]]}]}],"s":[{},[0,0,3]],"t":[{},[5]]}],"h":[{},[0,5]],"i":[{"l":[{"i":[{"n":[{},[0,0,4,3]]}]}],"s":[{},[1]]}],"j":[{},[0,5]],"k":[{},[0,5]],"l":[{"e":[{},[0,3]],"i":[{},[0,5]],"s":[{},[0,0,0,1]]},[0,0,4]],"o":[{"m":[{},[4,5]]},[1]],"p":[{},[0,5]],"r":[{"e":[{},[0,5]]}],"s":[{"t":[{},[0,3]],"u":[{},[0,5]]}],"t":[{},[0,5]],"u":[{},[3]],"æ":[{"r":[{"d":[{},[3]],"k":[{},[1]]}]}],"å":[{},[5]]}],"y":[{"a":[{},[0,3]],"d":[{"r":[{},[0,5]]}],"e":[{},[0,3]],"k":[{"e":[{},[0,3]],"i":[{},[0,5]],"l":[{"i":[{},[0,0,3]]}],"o":[{},[0,3]],"s":[{},[0,0,4,5]],"v":[{},[0,3]]}],"l":[{"i":[{},[0,5]],"o":[{},[0,5]]}],"m":[{"u":[{},[0,5]]}],"n":[{"s":[{},[0,0,0,5]]}],"o":[{},[0,5]],"p":[{"e":[{},[0,1]],"i":[{},[0,3]]}],"r":[{"e":[{"k":[{},[0,0,3]]},[0,3]],"i":[{},[0,3]]}],"s":[{"i":[{},[0,3]]}],"t":[{"i":[{},[0,3]],"r":[{},[0,5,3]]}],"v":[{"e":[{},[0,5]],"æ":[{},[0,5]]}]}],"z":[{"i":[{"o":[{},[0,0,5]]}]}],"æ":[{"b":[{"l":[{},[0,0,3]]}],"c":[{},[0,3]],"e":[{},[0,3]],"g":[{"a":[{},[0,0,5]],"e":[{"k":[{},[0,4]]}],"r":[{},[0,4,5]],"s":[{},[0,0,0,5]]}],"i":[{},[0,5]],"k":[{"v":[{},[0,5]]}],"l":[{"l":[{"e":[{},[0,0,0,0,4]]}]}],"n":[{"d":[{"r":[{},[0,0,1]]}]}],"o":[{},[0,5]],"r":[{"e":[{},[0,1]],"g":[{"r":[{},[0,0,4,5]]}],"i":[{},[0,3]],"m":[{"a":[{},[0,0,4]],"o":[{},[0,0,4]]}],"s":[{},[0,0,5]]}],"s":[{"i":[{},[0,5]],"o":[{},[0,3]],"t":[{"e":[{},[0,3]]}]}],"v":[{"e":[{},[0,3]]}]}],"ø":[{"d":[{"e":[{},[0,0,0,5]]}],"e":[{},[0,3]],"j":[{"e":[{},[0,1]]}],"k":[{"e":[{},[0,3]]}],"l":[{"e":[{},[0,3]]}],"m":[{"s":[{},[0,0,0,5]]}],"n":[{"s":[{"t":[{},[0,0,3]]}],"t":[{},[0,0,4,3]]}],"r":[{"e":[{},[0,1]],"i":[{},[0,3]],"n":[{"e":[{},[0,0,0,0,3]]}],"o":[{},[0,0,5]]}],"v":[{"e":[{},[0,1]]}]}],"å":[{"d":[{},[0,1]],"e":[{},[0,1]],"h":[{},[0,5]],"l":[{},[0,3]],"r":[{"e":[{},[0,3]],"s":[{"t":[{},[0,0,0,5]]}]}],"s":[{"k":[{},[0,5]]}],"t":[{},[0,3]]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
