(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsElMonoton = factory();
  }
})(this, function () {
  var patterns =
    '{"α":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"η":[{},[0,2]],"ϊ":[{},[0,2]],"ϋ":[{},[0,2]]},[0,1]],"ε":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ϊ":[{},[0,2]],"ϋ":[{},[0,2]]},[0,1]],"η":[{"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"α":[{},[0,2]],"ά":[{},[0,2]],"ά":[{},[0,2]],"ε":[{},[0,2]],"έ":[{},[0,2]],"έ":[{},[0,2]],"ο":[{},[0,2]],"ό":[{},[0,2]],"ό":[{},[0,2]],"ω":[{},[0,2]],"ώ":[{},[0,2]],"ώ":[{},[0,2]]},[0,1]],"ι":[{"α":[{},[0,2]],"ά":[{},[0,2]],"ά":[{},[0,2]],"ε":[{},[0,2]],"έ":[{},[0,2]],"έ":[{},[0,2]],"ο":[{},[0,2]],"ό":[{},[0,2]],"ό":[{},[0,2]],"ω":[{},[0,2]],"ώ":[{},[0,2]],"ώ":[{},[0,2]]},[0,1]],"ο":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ε":[{"ι":[{},[0,2]]}],"η":[{},[0,2]],"ϊ":[{"ό":[{},[0,3,3]],"ό":[{},[0,3,3]]},[0,2]]},[0,1]],"υ":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"α":[{},[0,2]],"ά":[{},[0,2]],"ά":[{},[0,2]],"ο":[{},[0,2]],"ό":[{},[0,2]],"ό":[{},[0,2]],"ω":[{},[0,2]],"ώ":[{},[0,2]],"ώ":[{},[0,2]]},[0,1]],"ω":[{},[0,1]],"ϊ":[{},[0,1]],"ϋ":[{},[0,1]],"ά":[{"ι":[{".":[{},[0,3]]},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]],"η":[{".":[{},[0,3]]}]},[0,1]],"έ":[{"ι":[{},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]]},[0,1]],"ή":[{"υ":[{},[0,3]]},[0,1]],"ί":[{},[0,1]],"ό":[{"ι":[{".":[{},[0,3]]},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]],"η":[{".":[{},[0,3]]}]},[0,1]],"ύ":[{"ι":[{},[0,3]]},[0,1]],"ώ":[{},[0,1]],"ΐ":[{},[0,1]],"ΰ":[{},[0,1]],"ά":[{"ι":[{".":[{},[0,3]]},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]],"η":[{".":[{},[0,3]]}]}],"έ":[{"ι":[{},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]]}],"ή":[{"υ":[{},[0,3]]}],"ό":[{"ι":[{".":[{},[0,3]]},[0,2]],"ϊ":[{},[0,2]],"υ":[{},[0,3]],"η":[{".":[{},[0,3]]}]}],"ύ":[{"ι":[{},[0,3]]}],".":[{"ι":[{},[0,3]],"ί":[{},[0,3]],"ί":[{},[0,3]],"η":[{},[0,3]],"ή":[{},[0,3]],"ή":[{},[0,3]],"υ":[{},[0,3]],"ύ":[{},[0,3]],"ύ":[{},[0,3]],"β":[{},[0,4]],"γ":[{},[0,4]],"δ":[{},[0,4]],"ζ":[{},[0,4]],"θ":[{},[0,4]],"κ":[{},[0,4]],"λ":[{},[0,4]],"μ":[{},[0,4]],"ν":[{},[0,4]],"ξ":[{},[0,4]],"π":[{},[0,4]],"ρ":[{},[0,4]],"σ":[{},[0,4]],"ϲ":[{},[0,4]],"τ":[{},[0,4]],"φ":[{},[0,4]],"χ":[{},[0,4]],"ψ":[{},[0,4]]}],"β":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"β":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"ρ":[{".":[{},[4]]}]}],"γ":[{".":[{},[4]],"κ":[{".":[{},[4]],"φ":[{},[4,5,2]],"τ":[{"ζ":[{},[4,0,1]],"σ":[{},[4,0,1]],"ϲ":[{},[4,0,1]]},[4,1]],"ς":[{".":[{},[4]]}],"ϲ":[{".":[{},[4]]}],"σ":[{".":[{},[4]]}],"μ":[{"π":[{},[4,0,1]]}],"ν":[{"τ":[{},[4,0,1]]}]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"γ":[{},[4,1]],"β":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{"τ":[{},[4,5,2]]},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"λ":[{".":[{},[4]]}]}],"δ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"δ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"λ":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]]}],"ζ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ζ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"λ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]]}],"θ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"θ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"κ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]]}],"κ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"κ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[6]]},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"λ":[{".":[{},[4]]}],"τ":[{".":[{},[4]]}],"ς":[{".":[{},[6]]}]}],"λ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"λ":[{},[4,1]],"κ":[{"μ":[{},[4,5,2]]},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[4]]},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"ς":[{".":[{},[4]]}]}],"μ":[{".":[{},[4]],"π":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"τ":[{"ζ":[{},[4,0,1]],"σ":[{},[4,0,1]],"ϲ":[{},[4,0,1]]},[4,1]],"λ":[{".":[{},[4]]}],"ν":[{".":[{},[4]],"τ":[{},[4,0,1]]}],"ρ":[{".":[{},[4]]}]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"μ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"λ":[{},[4,1]],"ξ":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[4]]},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{"τ":[{},[4,5,2]]},[4,1]],"ς":[{".":[{},[4]]}]}],"ν":[{".":[{},[4]],"τ":[{".":[{},[4]],"\'":[{},[4]],"’":[{},[4]],"᾿":[{},[4]],"ζ":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[4]]},[4,1]],"ς":[{".":[{},[4]]}],"μ":[{"π":[{},[4,0,1]]}]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ν":[{},[4,1]],"κ":[{"φ":[{},[4,5,2]]},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"λ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[4]]},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"ς":[{".":[{},[4]]}]}],"ξ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"λ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"π":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]]}],"π":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"π":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]]}],"ρ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ρ":[{},[4,1]],"γ":[{"μ":[{},[4,5,2]]},[4,1]],"θ":[{"μ":[{},[4,5,2]]},[4,1]],"κ":[{"μ":[{},[4,5,2]]},[4,1]],"ξ":[{"τ":[{},[4,5,2]]},[4,1]],"β":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"λ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"π":[{},[4,1]],"σ":[{".":[{},[4]]},[4,1]],"ϲ":[{".":[{},[4]]},[4,1]],"τ":[{},[4,1]],"φ":[{"ν":[{},[4,5,2]]},[4,1]],"χ":[{"μ":[{},[4,5,2]]},[4,1]],"ψ":[{},[4,1]],"ς":[{".":[{},[4]]}]}],"σ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"σ":[{},[4,1]],"θ":[{"μ":[{},[0,0,2]]}],"δ":[{},[4,1]],"ζ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"ρ":[{},[4,1]],"ψ":[{},[4,1]],"τ":[{"φ":[{},[0,0,2]],".":[{},[4]]}],"κ":[{".":[{},[4]]}]}],"ϲ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ϲ":[{},[4,1]],"θ":[{"μ":[{},[0,0,2]]}],"δ":[{},[4,1]],"ζ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"ρ":[{},[4,1]],"ψ":[{},[4,1]],"τ":[{"φ":[{},[0,0,2]],".":[{},[4]]}],"κ":[{".":[{},[4]]}]}],"ς":[{".":[{},[4]]}],"τ":[{".":[{},[4]],"ζ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"μ":[{},[0,0,2]]}],"σ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"γ":[{"κ":[{},[4,0,1]]}],"μ":[{"π":[{},[4,0,1]]}],"ν":[{"τ":[{},[4,0,1]]}]}],"ϲ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"γ":[{"κ":[{},[4,0,1]]}],"μ":[{"π":[{},[4,0,1]]}],"ν":[{"τ":[{},[4,0,1]]}]}],"ς":[{".":[{},[4]]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"τ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"λ":[{".":[{},[4]]}],"ρ":[{".":[{},[4]]}]}],"φ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"φ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"κ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"χ":[{},[4,1]],"ψ":[{},[4,1]],"τ":[{".":[{},[4]]}]}],"χ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"χ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"κ":[{},[4,1]],"μ":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"φ":[{},[4,1]],"ψ":[{},[4,1]],"τ":[{".":[{},[4]]}]}],"ψ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ψ":[{},[4,1]],"β":[{},[4,1]],"γ":[{},[4,1]],"δ":[{},[4,1]],"ζ":[{},[4,1]],"θ":[{},[4,1]],"κ":[{},[4,1]],"λ":[{},[4,1]],"μ":[{},[4,1]],"ν":[{},[4,1]],"ξ":[{},[4,1]],"π":[{},[4,1]],"ρ":[{},[4,1]],"σ":[{},[4,1]],"ϲ":[{},[4,1]],"τ":[{},[4,1]],"φ":[{},[4,1]],"χ":[{},[4,1]]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
