(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsLv = factory();
  }
})(this, function () {
  var patterns =
    '{"d":[{"z":[{"e":[{"m":[{"e":[{},[4,5,0,1]]}]}]},[0,4]],"ž":[{},[0,4]],"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"a":[{"i":[{},[0,2]],"u":[{"g":[{"s":[{"t":[{},[0,0,0,2,2,3]]}]}]},[0,2]],"č":[{"a":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"ū":[{},[0,1]],"g":[{"ā":[{},[0,0,1]]}]}],"n":[{"ā":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"r":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"b":[{"e":[{},[0,0,0,1]]}]}]}],"č":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"k":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]]}],"r":[{"ē":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"s":[{"t":[{"e":[{},[0,0,0,1]]}]}]}],"k":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]]}]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"m":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"i":[{},[0,0,0,1]]}]}],"l":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"a":[{},[0,0,0,1]]}]}],"c":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"j":[{"ē":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"c":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"s":[{"p":[{"ē":[{},[0,0,0,1]]}]}]}],"z":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"s":[{"a":[{},[0,0,1]]}],"d":[{"z":[{"e":[{},[0,0,0,1]]}]}]}],"d":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ž":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}]}],"f":[{"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"b":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"ņ":[{"o":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"r":[{"a":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"ļ":[{"ī":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"c":[{"e":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]]}],"ķ":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"e":[{},[0,0,1]]}],"š":[{"p":[{"a":[{},[0,0,0,1]]}]}]}],"m":[{"e":[{},[0,0,1]]}],"b":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"č":[{"ū":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"f":[{"i":[{},[0,0,1]]}],"ņ":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"š":[{"ū":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"l":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"ū":[{},[0,0,1]]}]}],"k":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"ņ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]]}]}],"d":[{"a":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"v":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"z":[{"e":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"n":[{"i":[{},[0,0,0,1]]}]}],"j":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ž":[{"u":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]]}],"p":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"k":[{"ā":[{},[0,0,1]],"r":[{"ū":[{},[0,0,0,1]]}]}],"m":[{"i":[{},[0,0,1]]}]}],"c":[{"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"h":[{"ē":[{},[0,0,1]]}],"g":[{"r":[{"ā":[{},[0,0,1]]}]}]}],"p":[{"ī":[{},[0,1]],"ē":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{"k":[{"š":[{},[0,0,0,0,2,3]]}],"u":[{},[0,0,1]]},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"d":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"z":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"ž":[{"i":[{},[0,0,1]]}]}],"š":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"m":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"c":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"s":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]]}]}],"p":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"e":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"ļ":[{"a":[{},[0,0,0,1]]}]}],"t":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"u":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}]}],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"ģ":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"z":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"r":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"n":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"g":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"f":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"č":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ņ":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"b":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"ķ":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"j":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"d":[{"r":[{"a":[{},[0,0,0,1]]}]}]}],"h":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"ž":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"f":[{"ī":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"b":[{"e":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"c":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1]]}]}],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"h":[{"ā":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]]}]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"t":[{"i":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"g":[{"r":[{"ī":[{},[0,0,1]]}]}]}],"z":[{"ī":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"d":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]]}]}],"b":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"r":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}]}],"k":[{"e":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"s":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"e":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]]}]}],"m":[{"ē":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"d":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}],"s":[{"p":[{"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"g":[{"u":[{},[0,0,0,1]]}],"v":[{"i":[{},[0,0,0,1]]}],"d":[{"e":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"m":[{"ī":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"s":[{"a":[{},[0,0,0,1]]}],"l":[{"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"j":[{"a":[{},[0,0,0,1]]}]}]}],"š":[{"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ķ":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ņ":[{"o":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"s":[{"v":[{"ā":[{},[0,0,0,1]]}]}]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{"ņ":[{},[0,0,3,0,4,3]]},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ļ":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"ņ":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"g":[{"r":[{"a":[{},[0,0,0,1]]}]}]}],"g":[{"a":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,1]]}]}],"r":[{"i":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"k":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ķ":[{"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{"ā":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"m":[{"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"d":[{"a":[{},[0,0,0,1]]}],"g":[{"a":[{},[0,0,0,1]]}],"v":[{"ī":[{},[0,0,0,1]]}],"p":[{"u":[{},[0,0,0,1]]}]}],"b":[{"u":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"g":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"s":[{"ē":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"c":[{"e":[{},[0,0,1]]}],"b":[{"ū":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]]}]}],"ķ":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ž":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}]}],"ģ":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"h":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"o":[{},[0,0,0,1]]}]}],"j":[{"u":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"d":[{"o":[{},[0,0,1]]}]}],"z":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"s":[{"p":[{"ē":[{},[0,0,0,1]]}]}]}],"r":[{"ī":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"d":[{"e":[{},[0,0,1]]}]}],"f":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ļ":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"m":[{"e":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"p":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"l":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"t":[{"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}]}],"l":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"d":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]]}]}],"z":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"d":[{"a":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]]}]}],"t":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]]}]}],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}],"š":[{"ā":[{},[0,0,1]]}]}],"j":[{"a":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"c":[{"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"m":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"p":[{"u":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]]}]}],"m":[{"a":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"t":[{"i":[{},[0,0,0,1]]}]}]}],"c":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]]}]}],"k":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ķ":[{"i":[{},[0,0,0,1]]}],"ņ":[{"a":[{},[0,0,0,1]]}]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"ī":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"n":[{"ā":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"j":[{"a":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}]}],"ķ":[{"ī":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{"ā":[{},[0,0,0,1]]}]}],"d":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"r":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"v":[{"a":[{},[0,0,0,1]]}]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"v":[{"ē":[{},[0,0,0,1]]}],"r":[{"i":[{},[0,0,0,1]]}]}],"b":[{"r":[{"i":[{},[0,0,0,1]]}]}]}],"g":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"m":[{"e":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}]}],"b":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"j":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"a":[{},[0,0,1]],"r":[{"ī":[{},[0,0,1]]}]}]}],"ģ":[{"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]]}],"ž":[{"ā":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"b":[{"r":[{"ī":[{},[0,0,1]]}]}],"s":[{"k":[{"ā":[{},[0,0,1]]}]}]}],"h":[{"u":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}],"k":[{"l":[{"u":[{},[0,0,0,1]]}]}]}],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ķ":[{"i":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]]}],"t":[{"ā":[{},[0,1]],"ī":[{},[0,1]],"ū":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"t":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"n":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ģ":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ž":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"ņ":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}],"ļ":[{"a":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"j":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"g":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ž":[{"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"m":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ķ":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"ņ":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"k":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"ļ":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}]}],"r":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}]}],"z":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"b":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"v":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"č":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"b":[{"u":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}]}],"l":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"t":[{"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"s":[{"k":[{"o":[{},[0,0,0,1]]}]}]}],"c":[{"i":[{},[0,0,1]]}],"f":[{"a":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}]}],"j":[{"a":[{},[0,0,1]]}],"d":[{"ē":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}]}],"g":[{"i":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"d":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"v":[{"ā":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"r":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"t":[{"a":[{},[0,0,1]]}]}],"g":[{"r":[{"ī":[{},[0,0,1]]}]}]}]}],"i":[{"e":[{},[0,2]],"u":[{},[0,2]],"t":[{"a":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"ū":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"l":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]]}]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]]}],"č":[{"e":[{},[0,0,1]]}]}],"r":[{"ē":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"m":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"b":[{"ā":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"d":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"z":[{"i":[{},[0,0,0,1]]}]}],"r":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"l":[{"a":[{},[0,0,0,1]]}]}],"s":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"k":[{"a":[{},[0,0,0,1]]}],"l":[{"e":[{},[0,0,0,1]]}]}],"t":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"c":[{"ē":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]]}],"š":[{"ķ":[{"i":[{},[0,0,0,1]]}]}]}],"c":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"k":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]},[0,0,2,3]],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"i":[{},[0,0,0,1]]}]}],"l":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]},[0,0,2,3]],"n":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ņ":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"n":[{"i":[{},[0,0,0,1]]}],"t":[{"i":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}]}]}],"š":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"k":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"d":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"z":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"i":[{},[0,0,0,1]]}]}],"n":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"p":[{"u":[{},[0,0,0,1]]}],"m":[{"i":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]]}],"k":[{"a":[{},[0,0,0,1]]}],"l":[{"i":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}],"d":[{"e":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]]}]}]}],"l":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"g":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"p":[{"ē":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"d":[{"a":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]]}]}]}],"s":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"n":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"m":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]]}]}],"r":[{"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"l":[{"ā":[{},[0,0,0,1]]}]}],"s":[{"e":[{},[0,0,1]],"t":[{"u":[{},[0,0,0,1]]}],"v":[{"ā":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"e":[{},[0,0,0,1]]}]}],"v":[{"a":[{},[0,0,1]]}]}],"t":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"k":[{"u":[{},[0,0,0,1]]}]}]}],"ž":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}]}]}],"b":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"j":[{"u":[{},[0,0,1]]}]}],"v":[{"i":[{},[0,0,1]],"j":[{"a":[{},[0,0,1]]}]}],"ģ":[{"e":[{},[0,0,1]]}]}],"č":[{"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]]}],"š":[{"o":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"ķ":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"j":[{"ā":[{},[0,0,1]]}],"b":[{"r":[{"ū":[{},[0,0,1]]}]}]}],"k":[{"e":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"r":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]]}],"s":[{"t":[{"ē":[{},[0,0,0,1]]}],"p":[{"ē":[{},[0,0,0,1]]}]}]}],"s":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ķ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"p":[{"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]]}]}],"m":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"z":[{"o":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"h":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"c":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"č":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"d":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ž":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"m":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"f":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"g":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ķ":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"b":[{"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"n":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"p":[{"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"r":[{"ū":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"ļ":[{"a":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]]}]}],"t":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"ī":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"l":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"ķ":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"m":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"ž":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"v":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}]}],"ģ":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"j":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]]}]}],"g":[{"i":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"z":[{"a":[{},[0,0,1]],"d":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"f":[{"r":[{"ī":[{},[0,0,1]]}]}],"ž":[{"ņ":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}]}],"f":[{"o":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}],"š":[{"t":[{"e":[{},[0,0,1]]}]}]}],"ķ":[{"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"v":[{"e":[{},[0,0,1]]}],"s":[{"k":[{"ā":[{},[0,0,1]]}]}]}],"ž":[{"e":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"n":[{"ā":[{},[0,0,1]]}]}],"s":[{"k":[{"ā":[{},[0,0,1]]}]}]}],"h":[{"a":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]]}],"s":[{"v":[{"ē":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]]}]}]}],"b":[{"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]]}]}]}],"n":[{"o":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"z":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,0,1]]}]}],"k":[{"o":[{},[0,0,1]]}]}],"t":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"f":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"p":[{"ū":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"s":[{"ū":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"u":[{},[0,0,0,1]]}]}],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"g":[{"r":[{"ē":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}]}],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{"ī":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"t":[{"ē":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}],"l":[{"i":[{},[0,0,0,1]]}]}],"š":[{"ķ":[{"i":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}]}],"c":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"g":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]]}],"s":[{"t":[{"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}]}],"j":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ķ":[{"i":[{},[0,0,1]]}]}],"v":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"č":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ž":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"ž":[{"u":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"c":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"t":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"d":[{"ī":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"r":[{"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"p":[{"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}],"k":[{"r":[{"ē":[{},[0,0,0,1]]}]}]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ž":[{"ā":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]]}],"p":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"ē":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"z":[{"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]]}],"l":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}]}],"p":[{"ā":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"s":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"n":[{"a":[{},[0,0,1]]}]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]]}],"f":[{"r":[{"ū":[{},[0,0,1]]}]}]}],"ņ":[{"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"d":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"š":[{"i":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}]}],"l":[{"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"k":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"t":[{"i":[{"e":[{},[0,0,2,1]]},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"n":[{"i":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]]}]}],"m":[{"e":[{},[0,0,1]]}]}],"p":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"u":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"c":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"s":[{"a":[{},[0,0,1]],"k":[{"a":[{},[0,0,0,1]]}]}],"v":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"b":[{"ā":[{},[0,0,1]],"r":[{"i":[{},[0,0,0,1]]}]}]}],"j":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"z":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}]}],"t":[{"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"p":[{"a":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"s":[{"t":[{"ē":[{},[0,0,0,1]]}],"m":[{"ā":[{},[0,0,0,1]]}],"k":[{"o":[{},[0,0,0,1]]}]}]}],"m":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"p":[{"a":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"ķ":[{"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]]}]}],"z":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,0,1]]}]}]}],"ž":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"l":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}],"p":[{"ē":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]]}],"b":[{"l":[{"ī":[{},[0,0,0,1]]}]}],"d":[{"r":[{"u":[{},[0,0,0,1]]}]}]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]]}]}],"h":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]]}],"f":[{"a":[{},[0,0,1]]}],"č":[{"a":[{},[0,0,1]]}]}],"c":[{"ē":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"s":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"n":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]]}]}],"t":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"p":[{"r":[{"o":[{},[0,0,0,1]]}]}]}],"s":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"b":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"d":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,0,1]]}],"f":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}]}],"s":[{"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"s":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"m":[{"i":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]],"r":[{"i":[{},[0,0,0,1]]}]}],"v":[{"ē":[{},[0,0,1]]}]}],"m":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"j":[{"u":[{},[0,0,1]]}],"m":[{"ī":[{},[0,0,1]]}]}],"p":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"n":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,0,1]]}]}],"s":[{"t":[{"ū":[{},[0,0,0,1]]}]}],"p":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"t":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"h":[{"r":[{"e":[{},[0,0,0,1]]}]}]}],"l":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ž":[{"ē":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"f":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"l":[{"ī":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]]}]}]}],"ļ":[{"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"d":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"ķ":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"r":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}],"b":[{"u":[{},[0,0,1]]}],"k":[{"r":[{"ā":[{},[0,0,1]]}]}],"s":[{"l":[{"i":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}]}]}],"ģ":[{"e":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]]}],"j":[{"ī":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"k":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]]}]}],"p":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"s":[{"k":[{"ā":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]]}]}]}]}],"e":[{"i":[{},[0,2]],"u":[{},[0,2]],"č":[{"ū":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"t":[{"u":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"z":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"s":[{"z":[{"ā":[{},[0,0,0,1]]}]}]}],"l":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"m":[{"e":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"s":[{"n":[{"i":[{},[0,0,0,1]]}]}]}],"v":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]]}]}],"t":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"s":[{"p":[{"ē":[{},[0,0,0,1]]}]}]}],"d":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"z":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"r":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"š":[{"e":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"p":[{"ē":[{},[0,0,0,1]]}]}],"f":[{"ē":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]]}],"p":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"ē":[{},[0,0,0,1]]}]}],"t":[{"ī":[{},[0,0,1]]}]}],"m":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"n":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"ā":[{},[0,0,0,1]]}]}],"b":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,0,1]]}]}]}],"b":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]]}]}],"m":[{"e":[{},[0,0,1]]}]}],"r":[{"ū":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ž":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"f":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"j":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"h":[{"i":[{},[0,0,1]]}]}],"h":[{"ā":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"n":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"b":[{"ū":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"l":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"š":[{"e":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ū":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"p":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"ķ":[{"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"ū":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"b":[{"ļ":[{"o":[{},[0,0,1]]}]}]}],"g":[{"ā":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"r":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"s":[{"p":[{"ē":[{},[0,0,0,1]]}]}]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"p":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"ī":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"p":[{"a":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"ļ":[{"u":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]]}]}],"d":[{"i":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ū":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"n":[{"i":[{},[0,0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"p":[{"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ž":[{"a":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"l":[{"i":[{},[0,0,0,1]]}]}],"r":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}]}],"f":[{"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ļ":[{"ū":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}]}],"j":[{"ū":[{},[0,0,1]]}],"ņ":[{"e":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,1]]}]}]}],"t":[{"ē":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"v":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"ņ":[{"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}]}],"r":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"l":[{"a":[{},[0,0,0,1]]}]}],"d":[{"e":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"ū":[{},[0,0,0,1]]}]}],"m":[{"o":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]]}]}],"d":[{"e":[{},[0,0,1]]}],"ķ":[{"ī":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"b":[{"o":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"r":[{"e":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"d":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}]}],"b":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"j":[{"e":[{},[0,0,1]]}]}],"r":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]]}],"b":[{"r":[{"i":[{},[0,0,0,1]]}]}]}],"c":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"s":[{"a":[{},[0,0,1]],"k":[{"o":[{},[0,0,0,1]]}]}],"h":[{"e":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"š":[{"ķ":[{"i":[{},[0,0,0,1]]}]}]}],"p":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"h":[{"a":[{},[0,0,1]]}]}],"z":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"ņ":[{"a":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"p":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"j":[{"e":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"z":[{"u":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"i":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"t":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"n":[{"e":[{},[0,0,1]]}]}],"c":[{"e":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,0,1]]}]}]}],"s":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"p":[{"ē":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"n":[{"ī":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"s":[{"i":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"p":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]]}],"b":[{"ē":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"g":[{"e":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}],"l":[{"m":[{"e":[{},[0,0,0,1]]}]}]}],"c":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"h":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"d":[{"a":[{},[0,0,1]]}]}],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"d":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]]}]}],"v":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"n":[{"e":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"z":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"u":[{},[0,0,0,1]]}]}],"s":[{"t":[{"a":[{},[0,0,0,1]]}]}],"b":[{"l":[{"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}],"d":[{"r":[{"o":[{},[0,0,0,1]]}],"z":[{"i":[{},[0,0,0,1]]}]}],"š":[{"ķ":[{"i":[{},[0,0,0,1]]}]}]}],"ž":[{"o":[{},[0,0,1]]}],"č":[{"u":[{},[0,0,1]]}],"g":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"b":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"b":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"ž":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"j":[{"o":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}],"d":[{"z":[{"i":[{},[0,0,0,1]]}]}]}],"j":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"v":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}]}],"j":[{"i":[{},[0,1]],"ē":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"d":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]]}],"b":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"c":[{"e":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"ī":[{},[0,1]],"h":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"k":[{"ā":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]]}]}],"ķ":[{"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"t":[{"u":[{},[0,0,1]]}]}],"p":[{"ū":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"n":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]]}]}],"ļ":[{"ī":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"m":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ķ":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"z":[{"ī":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]]}]}],"d":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"b":[{"ū":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}]}],"r":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]]}],"s":[{"k":[{"a":[{},[0,0,1]]}]}]}],"s":[{"i":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"k":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}]}],"v":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}],"k":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"b":[{"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"n":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{"ē":[{},[0,0,1]]}]}],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"d":[{"a":[{},[0,0,1]]}],"c":[{"ē":[{},[0,0,1]]}]}],"v":[{"ē":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]]}],"l":[{"ū":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"s":[{"k":[{"i":[{},[0,0,1]]}]}]}],"f":[{"e":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"r":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"ž":[{"i":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"ģ":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"k":[{"r":[{"ū":[{},[0,0,0,1]]}]}]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"f":[{"r":[{"ē":[{},[0,0,1]]}]}]}],"k":[{"i":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"ū":[{},[0,1]],"t":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"d":[{"o":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"u":[{},[0,0,0,1]]}]}],"t":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{"o":[{},[0,0,0,1]]}],"r":[{"e":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"m":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"č":[{"e":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"e":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}],"l":[{"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"s":[{"k":[{"ā":[{},[0,0,0,1]]}]}]}],"l":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"š":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"p":[{"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ķ":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"z":[{"i":[{},[0,0,0,1]]}]}],"v":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"n":[{"ī":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,0,1]]}]}]}],"n":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"z":[{"ē":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}]}],"ģ":[{"i":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]]}],"ņ":[{"ē":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"n":[{"o":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"ķ":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"ā":[{},[0,0,1]],"k":[{"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"b":[{"r":[{"a":[{},[0,0,1]]}]}],"p":[{"l":[{"e":[{},[0,0,1]]}]}]}]}],"u":[{"i":[{},[0,2]],"n":[{"o":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"v":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"č":[{"i":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"s":[{"z":[{"i":[{},[0,0,0,1]]}],"n":[{"o":[{},[0,0,0,1]]}],"m":[{"a":[{},[0,0,0,1]]}],"g":[{"a":[{},[0,0,0,1]]}]}]}],"c":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"z":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ž":[{"a":[{},[0,0,1]]}]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"s":[{"i":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"š":[{"ķ":[{"i":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}],"s":[{"t":[{"ē":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}]}],"z":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"b":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"s":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"p":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]]}],"b":[{"ī":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"d":[{"r":[{"o":[{},[0,0,0,1]]}],"z":[{"ē":[{},[0,0,0,1]]}]}],"g":[{"r":[{"ē":[{},[0,0,0,1]]}]}]}],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"j":[{"e":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"f":[{"t":[{"e":[{},[0,0,1]]}]}]}],"t":[{"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"b":[{"o":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"n":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]]}]}]}],"z":[{"u":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"g":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ļ":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"n":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ķ":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"m":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"b":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"s":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"u":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"ī":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"p":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ļ":[{"a":[{},[0,0,0,1]]}],"r":[{"e":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]]}]}],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"p":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"c":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ņ":[{"a":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"ģ":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"d":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"ž":[{"i":[{},[0,0,1]]}]}],"č":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ķ":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"j":[{"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"h":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"k":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ļ":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}]}]}],"ņ":[{"ā":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"ģ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ķ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"ģ":[{"i":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"n":[{"i":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ļ":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ķ":[{"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"ē":[{},[0,0,0,1]]}],"k":[{"a":[{},[0,0,0,1]]}],"r":[{"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}],"v":[{"ē":[{},[0,0,0,1]]}],"s":[{"i":[{},[0,0,0,1]]}],"c":[{"e":[{},[0,0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}]}],"š":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"s":[{"t":[{"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]]}]}]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"p":[{"r":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"z":[{"n":[{"a":[{},[0,0,1]]}]}]}],"s":[{"ē":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"p":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"m":[{"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"j":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"ē":[{},[0,0,1]]}],"t":[{"ē":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"p":[{"o":[{},[0,0,0,1]]}]}],"v":[{"e":[{},[0,0,1]]}],"k":[{"n":[{"ā":[{},[0,0,0,1]]}]}]}],"g":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"c":[{"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"d":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]]}]}],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]]}]}],"s":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"i":[{},[0,0,0,1]]}]}],"l":[{"o":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}]}],"f":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]]}],"č":[{"u":[{},[0,0,1]]}]}],"ķ":[{"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"k":[{"o":[{},[0,0,1]]}]}],"r":[{"ū":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"s":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"m":[{"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"r":[{"ū":[{},[0,0,0,1]]}]}],"p":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"f":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"s":[{"i":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]]}]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}]}],"v":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"c":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]]}]}],"p":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"c":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"z":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"r":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}]}],"ņ":[{"i":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}]}],"r":[{"a":[{},[0,0,1]]}],"j":[{"o":[{},[0,0,1]],"m":[{"a":[{},[0,0,0,1]]}]}]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"j":[{"ā":[{},[0,0,1]]}]}],"d":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"z":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"j":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ķ":[{"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ģ":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}],"č":[{"ū":[{},[0,0,1]]}]}],"č":[{"i":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"k":[{"a":[{},[0,0,1]]}]}],"c":[{"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]]}],"k":[{"i":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"š":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]]}]}],"t":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"s":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"t":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"m":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}]}],"ļ":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"ņ":[{"ī":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"č":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"p":[{"l":[{"ē":[{},[0,0,1]]}]}]}],"m":[{"u":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"c":[{"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"j":[{"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"s":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"p":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"b":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"j":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]]}],"b":[{"r":[{"ū":[{},[0,0,0,1]]}]}]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"ļ":[{"a":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"ī":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ķ":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ņ":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"s":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}]}],"b":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}],"ģ":[{"i":[{},[0,0,1]]}],"ž":[{"o":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"g":[{"l":[{"u":[{},[0,0,1]]}]}]}],"l":[{"u":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"s":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"n":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"d":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"z":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"g":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}]}],"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}],"s":[{"t":[{"e":[{},[0,0,0,1]]}]}]}],"b":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"š":[{"a":[{},[0,0,1]]}],"s":[{"t":[{"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"p":[{"u":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}]}],"f":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}]}],"j":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"p":[{"ū":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}],"v":[{"a":[{},[0,0,0,1]]}]}],"z":[{"o":[{},[0,0,1]],"v":[{"a":[{},[0,0,0,1]]}]}],"r":[{"a":[{},[0,0,1]]}],"k":[{"v":[{"a":[{},[0,0,0,1]]}]}],"p":[{"l":[{"a":[{},[0,0,0,1]]}]}]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ņ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"z":[{"n":[{"a":[{},[0,0,1]]}]}]}],"v":[{"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"s":[{"a":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]]}],"b":[{"r":[{"a":[{},[0,0,1]]}]}]}],"ž":[{"u":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"p":[{"u":[{},[0,0,1]]}]}],"š":[{"ā":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"ķ":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"ē":[{},[0,0,1]]}]}],"č":[{"o":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}]}],"j":[{"a":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"b":[{"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"n":[{"a":[{},[0,0,1]]}],"s":[{"ī":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}]}],"l":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"j":[{"e":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"k":[{"r":[{"ē":[{},[0,0,1]]}]}]}],"p":[{"o":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"j":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"m":[{"a":[{},[0,0,1]]}],"g":[{"r":[{"a":[{},[0,0,0,1]]}]}]}],"r":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}]}],"f":[{"o":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"l":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"d":[{"ī":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ž":[{"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]]}],"r":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"s":[{"k":[{"ā":[{},[0,0,0,1]]}]}]}],"p":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"z":[{"i":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"b":[{"a":[{},[0,0,0,1]]}],"c":[{"ī":[{},[0,0,0,1]]}],"m":[{"a":[{},[0,0,0,1]]}],"s":[{"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"k":[{"a":[{},[0,0,0,1]]}],"t":[{"ū":[{},[0,0,0,1]]}]}],"d":[{"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"k":[{"ā":[{},[0,0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"v":[{"ī":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}],"g":[{"a":[{},[0,0,0,1]]}],"r":[{"u":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}],"p":[{"u":[{},[0,0,0,1]],"l":[{"a":[{},[0,0,0,1]]}]}],"n":[{"o":[{},[0,0,0,1]]}],"š":[{"ķ":[{"a":[{},[0,0,0,1]]}]}]}],"m":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"p":[{"i":[{},[0,0,1]]}]}],"b":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"h":[{"a":[{},[0,1]],"t":[{"ā":[{},[0,0,1]]}]}]}],"o":[{"i":[{},[0,2]],"u":[{},[0,2]],"p":[{"ī":[{},[0,1]],"ū":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"r":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]]}]}],"p":[{"l":[{"a":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}]}],"m":[{"ī":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}]}],"p":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"v":[{"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"k":[{"r":[{"a":[{},[0,0,1]]}]}]}],"k":[{"ā":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"i":[{},[0,1]],"t":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"r":[{"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]],"v":[{"ē":[{},[0,0,1]]}]}],"b":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"n":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"r":[{"ū":[{},[0,0,0,1]]}]}],"t":[{"e":[{},[0,0,1]],"r":[{"o":[{},[0,0,0,1]]}]}]}],"l":[{"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"š":[{"ņ":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}]}]}],"č":[{"i":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]]}],"ļ":[{"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"š":[{"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"b":[{"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"r":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"p":[{"i":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"t":[{"r":[{"u":[{},[0,0,0,1]]}]}]}],"v":[{"e":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"v":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"m":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}]}],"f":[{"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]]}]}],"r":[{"i":[{},[0,0,1]]}]}],"r":[{"ē":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"ū":[{},[0,1]],"b":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"c":[{"i":[{},[0,0,1]]}]}],"k":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"l":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"f":[{"e":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"j":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"p":[{"r":[{"e":[{},[0,0,0,1]]}]}]}],"g":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"h":[{"i":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"d":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"z":[{"n":[{"i":[{},[0,0,0,1]]}]}]}],"v":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"ķ":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ž":[{"e":[{},[0,0,1]]}],"č":[{"ē":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"k":[{"ā":[{},[0,0,1]]}]}],"z":[{"ā":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"d":[{"ē":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ū":[{},[0,1]],"ž":[{"u":[{},[0,1]],"i":[{},[0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"z":[{"ī":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"n":[{"i":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"š":[{"u":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}]}],"j":[{"o":[{},[0,0,1]]}],"g":[{"r":[{"u":[{},[0,0,1]]}]}],"s":[{"l":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}]}]}],"l":[{"ī":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"l":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}]}],"m":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"f":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"p":[{"o":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"ū":[{},[0,0,1]]}],"t":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{"e":[{},[0,0,1]]}]}],"d":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"k":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}]}],"g":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"b":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"j":[{"e":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]]}]}],"f":[{"o":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"r":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}],"h":[{"u":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"r":[{"o":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}]}],"ģ":[{"ē":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]]}],"š":[{"a":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"p":[{"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"s":[{"i":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"ķ":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}]}],"t":[{"o":[{},[0,1]],"ū":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"n":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"d":[{"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]},[0,0,2,1,2]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]},[0,0,2,1,2]],"z":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"b":[{"u":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"r":[{"ī":[{},[0,0,1]]}]}],"g":[{"r":[{"i":[{},[0,0,1]]}]}],"p":[{"l":[{"ā":[{},[0,0,1]]}]}],"s":[{"p":[{"ē":[{},[0,0,1]]}]}]}],"z":[{"o":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"ū":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"g":[{"ū":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"r":[{"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"h":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"s":[{"k":[{"ā":[{},[0,0,0,1]]}]}]}],"l":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}]}],"ķ":[{"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"v":[{"ā":[{},[0,0,1]]}]}],"ņ":[{"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]]}],"c":[{"ū":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"z":[{"ī":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}],"l":[{"ū":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"ū":[{},[0,0,1]]}]}],"j":[{"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"n":[{"e":[{},[0,0,1]]}]}],"n":[{"ī":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"z":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"n":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"e":[{},[0,0,0,1]]}]}],"d":[{"a":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}],"h":[{"ī":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"p":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"r":[{"ē":[{},[0,0,0,1]]}]}]}],"f":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"c":[{"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"b":[{"ū":[{},[0,0,1]]}]}],"v":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"n":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"s":[{"m":[{"ē":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}]}]}],"ž":[{"a":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"ū":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ņ":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"c":[{"o":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]]}]}],".":[{"v":[{"i":[{"s":[{"a":[{".":[{},[0,0,1,2]]},[0,0,0,3,2]],"ā":[{".":[{},[0,0,1,2]]},[0,0,0,3,2]],"i":[{".":[{},[0,0,1,2]],"e":[{"m":[{".":[{},[0,0,1,2]]}]}]},[0,0,0,3,2]],"o":[{"s":[{".":[{},[0,0,1,2]]}]},[0,0,0,3,2]],"u":[{".":[{},[0,0,1,2]]},[0,0,0,3,2]],"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]}],"e":[{"n":[{},[0,0,0,2,1]]}]}]}],"j":[{"ā":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{"e":[{},[0,0,3,0,1]],"z":[{},[0,0,3,0,1]]},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]],"n":[{"o":[{},[0,0,3,0,1]]}]}]}],"n":[{"e":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"a":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{"i":[{"z":[{},[0,0,3,0,0,1]]}],"p":[{},[0,0,3,0,1]],"t":[{},[0,0,3,0,1]]},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{"e":[{},[0,0,3,0,1]],"n":[{},[0,0,3,0,1]],"z":[{},[0,0,3,0,1]]},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{"z":[{},[0,0,3,0,1]]},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"o":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}]}],"i":[{"e":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"z":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}]}],"p":[{"a":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"i":[{"e":[{"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"a":[{},[0,0,0,3,2]],"ā":[{},[0,0,0,3,2]],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"i":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"o":[{},[0,0,0,3,2]],"u":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]}]}],"ā":[{"r":[{"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"a":[{},[0,0,0,3,2]],"ā":[{},[0,0,0,3,2]],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"i":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"o":[{},[0,0,0,3,2]],"u":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]}]}],"r":[{"i":[{"e":[{"k":[{"š":[{},[0,0,0,0,0,2,1]]}]}]}]}]}],"s":[{"a":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"p":[{"i":[{"l":[{"g":[{"t":[{},[0,0,0,0,2,1]]}]}]}]}]}],"u":[{"z":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}]}],"a":[{"i":[{"z":[{"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"a":[{},[0,0,0,3,2]],"ā":[{},[0,0,0,3,2]],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"i":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"o":[{},[0,0,0,3,2]],"u":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]},[0,0,4,5]]}],"p":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"t":[{"s":[{"p":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]},[0,0,1,2]],"c":[{},[0,0,1,2]],"t":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]},[0,0,1,2]],"f":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{"v":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]},[0,0,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"ž":[{"v":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"š":[{"ļ":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"ķ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{"r":[{},[0,0,1,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"ņ":[{},[0,0,1,2]],"ļ":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"b":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"ž":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"z":[{"v":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"f":[{"r":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"v":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"h":[{"r":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"m":[{"n":[{},[0,0,1,2]]}],"a":[{},[0,0,3,2]],"ā":[{},[0,0,3,2]],"e":[{"j":[{},[0,0,3,2]]},[0,0,3,2]],"ē":[{},[0,0,3,2]],"i":[{},[0,0,3,2]],"ī":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ū":[{},[0,0,3,2]]}],"d":[{"ā":[{"m":[{},[0,0,0,2,3]]}]}]}],"b":[{"e":[{"z":[{"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"a":[{},[0,0,0,3,2]],"ā":[{},[0,0,0,3,2]],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"i":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"o":[{},[0,0,0,3,2]],"u":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]}]}]}],"e":[{"k":[{"s":[{"s":[{"p":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"t":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{"v":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"h":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"g":[{"l":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ž":[{"v":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]]}],"š":[{"ļ":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1,2]],"ķ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"p":[{"r":[{},[0,0,0,1,2]]},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"b":[{"r":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"p":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]]}],"k":[{"l":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"c":[{},[0,0,0,1,2]],"ņ":[{},[0,0,0,1,2]],"ļ":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1,2]]}],"d":[{"r":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"ž":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1,2]]}],"z":[{"v":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}],"f":[{"r":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"v":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"h":[{"r":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1,2]]}],"m":[{"n":[{},[0,0,0,1,2]]}],"a":[{},[0,0,0,3,2]],"ā":[{},[0,0,0,3,2]],"e":[{},[0,0,0,3,2]],"ē":[{},[0,0,0,3,2]],"i":[{},[0,0,0,3,2]],"ī":[{},[0,0,0,3,2]],"o":[{},[0,0,0,3,2]],"u":[{},[0,0,0,3,2]],"ū":[{},[0,0,0,3,2]]}]}]}],"t":[{"u":[{"r":[{"p":[{"m":[{},[0,0,0,2,1]]}]}]}]}]}],"ū":[{"r":[{"ē":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"k":[{"a":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"f":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"s":[{"t":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}]}]}],"g":[{"a":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}]}],"d":[{"a":[{},[0,0,1]]}],"k":[{"r":[{"i":[{},[0,0,1]]}]}]}],"t":[{"o":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"m":[{"a":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"g":[{"a":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}]}],"ķ":[{"e":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]]}],"c":[{"a":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]]}],"b":[{"ē":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]]}],"n":[{"ē":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"g":[{"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]]}],"t":[{"v":[{"e":[{},[0,0,1]]}]}]}],"p":[{"ā":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"s":[{"t":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}]}]}],"š":[{"ī":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"d":[{"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ļ":[{"o":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}]}],"d":[{"ī":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"z":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]]}],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"j":[{"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]]}],"z":[{"u":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"m":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}]}],"ž":[{"a":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"ņ":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]]}]}],"k":[{"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"l":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ķ":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"ņ":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]]}]}],"l":[{"u":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]]}],"ļ":[{"a":[{},[0,1]],"ī":[{},[0,1]]}],"s":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"k":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"m":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]]}]}],"n":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}]}],"ņ":[{"a":[{},[0,1]]}],"v":[{"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"n":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"s":[{"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"b":[{"e":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"p":[{"r":[{"o":[{},[0,0,1]]}]}]}]}],"ē":[{"ž":[{"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"v":[{"e":[{},[0,0,1]]}]}],"c":[{"ē":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"t":[{"e":[{},[0,0,1]]}],"n":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]]}],"t":[{"ā":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"v":[{"i":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"h":[{"o":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}]}],"k":[{"ē":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ņ":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ķ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"t":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"b":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}],"l":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"ļ":[{"u":[{},[0,0,1]]}],"m":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"j":[{"u":[{},[0,0,1]]}]}],"n":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"s":[{"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}]}],"p":[{"i":[{},[0,0,1]]}]}],"b":[{"u":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"t":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}]}],"d":[{"o":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"v":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"z":[{"e":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"n":[{"i":[{},[0,0,0,1]]}]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"d":[{"z":[{"i":[{},[0,0,1]]}]}]}],"ļ":[{"a":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"k":[{"o":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"t":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"k":[{"ū":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]]}]}],"v":[{"ē":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"r":[{"e":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]]}]}],"ķ":[{"i":[{},[0,1]],"ē":[{},[0,1]]}],"n":[{"e":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"m":[{"ī":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"p":[{"r":[{"ā":[{},[0,0,1]]}]}],"s":[{"k":[{"ā":[{},[0,0,1]]}]}]}],"s":[{"ī":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"t":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,0,1]]}]}]}],"l":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"t":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"c":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"ē":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}]}],"z":[{"o":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"č":[{"ū":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"g":[{"r":[{"ā":[{},[0,0,1]]}]}]}],"r":[{"o":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ķ":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]]}]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ķ":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"s":[{"i":[{},[0,0,1]],"t":[{"u":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}]}],"l":[{"i":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"s":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"v":[{"ī":[{},[0,0,0,1]]}]}],"z":[{"ā":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,0,1]]}]}]}],"ļ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]]}]}],"p":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"b":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}]}],"n":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}]}],"g":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"l":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]]}],"š":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ļ":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"j":[{"u":[{},[0,0,1]]}]}],"v":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"s":[{"l":[{"i":[{},[0,0,0,1]]}],"s":[{"ū":[{},[0,0,0,1]]}],"v":[{"ē":[{},[0,0,0,1]]}]}]}],"d":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"ģ":[{"e":[{},[0,0,1]]}]}],"p":[{"ī":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}]}],"g":[{"i":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"n":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"t":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"d":[{"ē":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"š":[{"u":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"ļ":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"l":[{"ē":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ī":[{},[0,1]],"g":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"p":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"l":[{"ē":[{},[0,0,1]]}]}],"z":[{"ī":[{},[0,0,1]]}],"c":[{"u":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"j":[{"u":[{},[0,0,1]]}]}]}],"ņ":[{"o":[{},[0,1]],"d":[{"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ģ":[{"e":[{},[0,1]],"i":[{},[0,1]]}]}],"ā":[{"n":[{"i":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]]}],"p":[{"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"p":[{"ē":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}]}],"b":[{"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"j":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}]}],"l":[{"o":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"t":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"r":[{"e":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"k":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"c":[{"i":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}],"z":[{"ā":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"s":[{"t":[{"a":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}],"k":[{"ā":[{},[0,0,0,1]]}]}]}],"k":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}],"l":[{"ā":[{},[0,0,1]]}]}],"r":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]]}]}],"z":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"g":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"š":[{"ā":[{},[0,0,1]],"t":[{"ā":[{},[0,0,1]]}],"ķ":[{"ē":[{},[0,0,1]]}]}]}],"r":[{"u":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"ū":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"b":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"ā":[{},[0,0,1]]}]}],"h":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"ē":[{},[0,0,1]],"r":[{"ī":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]]}]}],"p":[{"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"ū":[{},[0,0,0,1]]}],"ļ":[{"a":[{},[0,0,0,1]]}]}],"l":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"v":[{"e":[{},[0,0,0,1]]}]}]}],"v":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"v":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"č":[{"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"z":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ž":[{"i":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"d":[{"z":[{"i":[{},[0,0,0,1]]}]}]}],"t":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,1]]}]}],"v":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}]}],"c":[{"ī":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"ļ":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"ž":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"l":[{"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,0,1]],"u":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}],"d":[{"i":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}]}],"ņ":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"n":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"ļ":[{"ū":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"s":[{"t":[{"i":[{},[0,0,0,1]],"a":[{},[0,0,0,1]]}]}]}],"j":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"ū":[{},[0,0,1]],"ā":[{},[0,0,1]],"l":[{"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"ū":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ļ":[{"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"t":[{"a":[{},[0,0,0,1]]}]}]}],"r":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]]}],"ķ":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]]}],"f":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}]}]}],"č":[{"a":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"s":[{"ū":[{},[0,0,1]]}],"p":[{"l":[{"ē":[{},[0,0,1]]}]}]}],"g":[{"e":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"ū":[{},[0,1]],"n":[{"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"š":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"v":[{"i":[{},[0,0,0,1]]}]}]}]}],"f":[{"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"r":[{"i":[{},[0,0,1]]}]}],"š":[{"a":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ķ":[{"i":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"r":[{"u":[{},[0,0,1]]}]}]}],"t":[{"e":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"v":[{"i":[{},[0,0,1]],"ē":[{},[0,0,1]],"e":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}],"m":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"g":[{"ā":[{},[0,0,1]],"r":[{"i":[{},[0,0,0,1]]}]}],"m":[{"o":[{},[0,0,1]]}],"s":[{"l":[{"i":[{},[0,0,0,1]]}],"p":[{"i":[{},[0,0,0,1]],"ē":[{},[0,0,0,1]]}]}],"b":[{"r":[{"a":[{},[0,0,0,1]]}]}]}],"n":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{"ā":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]]}]}],"ņ":[{"u":[{},[0,0,1]]}],"b":[{"ū":[{},[0,0,1]]}],"l":[{"i":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}],"z":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]]}]}],"c":[{"e":[{},[0,0,1]]}]}],"p":[{"u":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]]}]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"l":[{"i":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}]}]}],"m":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"d":[{"i":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"l":[{"ā":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"b":[{"r":[{"a":[{},[0,0,1]]}]}]}],"j":[{"a":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"t":[{"u":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"b":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]]}]}],"d":[{"o":[{},[0,0,1]],"z":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}]}]}],"ļ":[{"o":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"d":[{"z":[{"i":[{},[0,0,1]]}]}]}],"v":[{"ē":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"d":[{"a":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"s":[{"t":[{"i":[{},[0,0,1]]}]}],"z":[{"v":[{"a":[{},[0,0,1]]}]}],"g":[{"r":[{"ū":[{},[0,0,1]]}]}]}],"ž":[{"o":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"n":[{"i":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]}]}],"ņ":[{"o":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"m":[{"u":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]}]}],"k":[{"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"t":[{"u":[{},[0,0,1]],"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"l":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"s":[{"t":[{"ā":[{},[0,0,0,1]]}]}]}],"š":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]],"ķ":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"r":[{"e":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"z":[{"i":[{},[0,0,1]]}]}],"ķ":[{"i":[{},[0,1]],"e":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"v":[{"e":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,1]],"ū":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"ī":[{},[0,1]],"t":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"n":[{"i":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"k":[{"u":[{},[0,0,1]]}]}],"k":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}]}],"d":[{"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ž":[{"ā":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"u":[{},[0,1]]}],"z":[{"i":[{},[0,1]],"e":[{},[0,1]],"ē":[{},[0,1]],"ī":[{},[0,1]]}],"m":[{"i":[{},[0,0,1]]}],"n":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}]}],"ģ":[{"ē":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"v":[{"e":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]}]}],"c":[{"ā":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]]}],"z":[{"ā":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"t":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]]}],"v":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"e":[{},[0,0,1]]}],"ģ":[{"e":[{},[0,0,1]]}]}]}],"ī":[{"z":[{"ē":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"r":[{"e":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]]}],"j":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}]}],"g":[{"a":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"l":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"ī":[{},[0,0,1]],"e":[{},[0,0,1]]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]]}],"t":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{"ā":[{},[0,0,0,1]]}]}],"n":[{"ē":[{},[0,0,1]]}]}],"n":[{"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"u":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]],"ē":[{},[0,0,1]],"s":[{"p":[{"ē":[{},[0,0,0,1]]}]}]}],"š":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1]]}],"z":[{"n":[{"a":[{},[0,0,1]]}]}],"ļ":[{"l":[{"a":[{},[0,0,1]]}]}]}],"t":[{"e":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"v":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ī":[{},[0,0,1]],"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"ņ":[{"u":[{},[0,0,1]],"m":[{"ē":[{},[0,0,1]]}],"g":[{"r":[{"i":[{},[0,0,0,1]]}]}]}],"c":[{"i":[{},[0,0,1]]}],"n":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}]}],"l":[{"ī":[{},[0,0,1]]}],"d":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}]}]}],"j":[{"a":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]]}],"r":[{"e":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"n":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"k":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"s":[{"ē":[{},[0,0,1]],"k":[{"a":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"š":[{"ķ":[{"i":[{},[0,0,1]]}]}]}],"ž":[{"ī":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"m":[{"e":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"š":[{"e":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"v":[{"ī":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ē":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"n":[{"i":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"s":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]]}]}],"m":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"z":[{"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"l":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"b":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]]}],"d":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"r":[{"ē":[{},[0,0,1]]}]}],"c":[{"i":[{},[0,0,1]]}],"k":[{"u":[{},[0,0,1]],"o":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"p":[{"i":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"t":[{"i":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1]]}]}],"b":[{"ē":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"t":[{"u":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"š":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"p":[{"ē":[{},[0,0,1]]}]}]}],"l":[{"e":[{},[0,1]],"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"z":[{"i":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"e":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"t":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"b":[{"ū":[{},[0,0,1]],"u":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1]],"k":[{"ā":[{},[0,0,1]]}],"t":[{"r":[{"ā":[{},[0,0,0,1]]}]}]}],"m":[{"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]],"r":[{"ū":[{},[0,0,1]]}]}]}],"ļ":[{"a":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"i":[{},[0,1]],"ā":[{},[0,1]],"ī":[{},[0,1]],"b":[{"ā":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1]]}],"k":[{"n":[{"ā":[{},[0,0,1]]}]}]}],"s":[{"ē":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ī":[{},[0,1]],"i":[{},[0,1]],"g":[{"a":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ž":[{"u":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]]}],"c":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"r":[{"ā":[{},[0,0,1]]}]}],"t":[{"u":[{},[0,0,1]],"i":[{},[0,0,1]],"ī":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"ē":[{},[0,0,1]],"o":[{},[0,0,1]],"ū":[{},[0,0,1]],"e":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"e":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"p":[{"a":[{},[0,0,1]]}],"t":[{"ū":[{},[0,0,1]]}]}],"v":[{"ē":[{},[0,0,1]],"i":[{},[0,0,1]],"a":[{},[0,0,1]]}],"f":[{"i":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"d":[{"e":[{},[0,0,1]]}],"š":[{"ķ":[{"i":[{},[0,0,1]]}]}]}],"k":[{"i":[{},[0,1]],"u":[{},[0,1]],"ā":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"a":[{},[0,1]],"l":[{"ī":[{},[0,0,1]],"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{"ē":[{},[0,0,1]],"a":[{},[0,0,1]],"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"ā":[{},[0,0,1]],"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]]}],"ļ":[{"u":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]],"a":[{},[0,0,1]],"i":[{},[0,0,1]]}],"b":[{"u":[{},[0,0,1]],"ū":[{},[0,0,1]]}],"š":[{"a":[{},[0,0,1]],"u":[{},[0,0,1]],"o":[{},[0,0,1]],"ķ":[{"o":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,0,1]],"ē":[{},[0,0,1]],"a":[{},[0,0,1]]}],"ņ":[{"a":[{},[0,0,1]]}]}],"p":[{"i":[{},[0,0,1]],"l":[{"a":[{},[0,0,1]]}]}],"z":[{"e":[{},[0,0,1]]}],"k":[{"ā":[{},[0,0,1]],"o":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"r":[{"ā":[{},[0,0,1]],"ū":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"i":[{},[0,0,1]],"a":[{},[0,0,1]],"t":[{"u":[{},[0,0,1]],"e":[{},[0,0,1]],"ē":[{},[0,0,1]],"ā":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"a":[{},[0,0,1]],"ī":[{},[0,0,1]],"m":[{"ē":[{},[0,0,0,1]]}],"s":[{"i":[{},[0,0,0,1]]}],"p":[{"i":[{},[0,0,0,1]]}],"č":[{"a":[{},[0,0,0,1]]}]}],"m":[{"ī":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"e":[{},[0,0,1]],"ā":[{},[0,0,1]],"ē":[{},[0,0,1]],"u":[{},[0,0,1]],"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"ā":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{"r":[{"o":[{},[0,0,0,1]]}]}]}],"ņ":[{"ā":[{},[0,0,1]]}],"g":[{"r":[{"u":[{},[0,0,1]],"a":[{},[0,0,1]]}]}]}],"d":[{"e":[{},[0,1]],"ā":[{},[0,1]],"i":[{},[0,1]],"ī":[{},[0,1]],"ē":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"a":[{},[0,1]],"z":[{"e":[{},[0,1]],"ī":[{},[0,1]],"ā":[{},[0,1]],"o":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"ē":[{},[0,1]],"a":[{},[0,1]],"j":[{"ū":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,0,1]],"ā":[{},[0,0,0,1]]}],"š":[{"i":[{},[0,0,0,1]]}],"t":[{"e":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"c":[{"i":[{},[0,0,0,1]]}],"k":[{"o":[{},[0,0,0,1]]}],"p":[{"r":[{"o":[{},[0,0,0,1]]}]}],"s":[{"k":[{"a":[{},[0,0,0,1]]}],"v":[{"a":[{},[0,0,0,1]]}]}]}],"l":[{"ī":[{},[0,0,1]],"a":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]]}],"n":[{"i":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"k":[{"o":[{},[0,0,1]]}],"m":[{"ē":[{},[0,0,1]]}]}],"š":[{"e":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]],"o":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"ķ":[{"i":[{},[0,0,1]]}],"ļ":[{"a":[{},[0,0,1]]}]}],"ģ":[{"e":[{},[0,1]],"i":[{},[0,1]]}],"p":[{"ā":[{},[0,1]],"a":[{},[0,1]],"ē":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"e":[{},[0,1]],"ī":[{},[0,1]],"r":[{"i":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]}],"s":[{"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]}]}],"ķ":[{"u":[{},[0,1]],"e":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"s":[{"a":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]}]}],"č":[{"u":[{},[0,1]],"o":[{},[0,1]]}],"ņ":[{"u":[{},[0,1]],"ā":[{},[0,1]],"a":[{},[0,1]],"i":[{},[0,1]],"n":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}]}],"f":[{"e":[{},[0,1]]}]}],"b":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"a":[{"l":[{"t":[{"m":[{"a":[{},[0,0,0,2,3]]}]}]}]}]}],"c":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"č":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"f":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}],"g":[{"a":[{"l":[{},[0,2,1]]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"ģ":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"h":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"j":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"k":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}],"g":[{"a":[{"l":[{},[0,2,1]]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"ā":[{"r":[{"t":[{"n":[{},[0,0,0,2,3]]}]}]}]}],"ķ":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"l":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"ļ":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"m":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"ē":[{"n":[{"e":[{"š":[{},[0,0,1,0,2,1]]}]}]}]}],"n":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"ņ":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"p":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"a":[{"d":[{"s":[{"m":[{"i":[{"t":[{},[1,0,1,2]]}]}]}]}],"t":[{"s":[{"t":[{"ā":[{},[0,0,2,3]]}]}]}],"s":[{"t":[{"k":[{},[0,0,2,2,3]],"m":[{},[0,0,2,2,3]],"s":[{".":[{},[0,0,2,2,2]]}]}]}],"r":[{"k":[{"s":[{".":[{},[0,0,2,2,2]]}],"e":[{"t":[{},[0,0,2,3]]}]}]}]}],"o":[{"r":[{"t":[{},[1]]}]}],"i":[{"r":[{"m":[{"r":[{},[0,0,0,2,1]],"k":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,2,1]]}]}]}]}],"r":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"s":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"a":[{"l":[{"s":[{".":[{},[0,0,2]]}],"d":[{"s":[{".":[{},[0,0,2]]}]},[0,0,2,2,1]]}]}]}],"š":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"r":[{"a":[{"n":[{"s":[{},[0,0,0,0,2]]}]}]}]}],"v":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}],"ē":[{"s":[{"t":[{"n":[{},[0,0,0,2,1]],"k":[{},[0,0,0,2,1]]}]}]}]}],"z":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}],"ž":[{"d":[{"a":[{"m":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}],"i":[{"e":[{"s":[{".":[{},[2,3,0,3]]}]}]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"g":[{"a":[{"n":[{"s":[{".":[{},[2,3]]}],"a":[{".":[{},[2,3,0,3]]}]}]}]}],"n":[{"i":[{"e":[{"k":[{"s":[{".":[{},[2,3]]}]}],"c":[{"e":[{".":[{},[2,3,0,0,3]]}]}]}]}],"ī":[{"c":[{"a":[{".":[{},[2,3,0,3]]}]}]}]}],"š":[{"a":[{"n":[{"a":[{".":[{},[2,3,0,3]]}],"ā":[{"s":[{".":[{},[2,3,0,3]]}]}]}]}]}],"t":[{"a":[{"l":[{"a":[{".":[{},[2,3,0,3]]}]}]}],"u":[{"v":[{"e":[{".":[{},[2,3,0,3]]}]}]}]}]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
