"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, // All reference data is imported first, so that can be assumed for ordering.
//
// sheetNameNormalised: {
//   model: 'ModelName' (defaults to `upperFirst(sheetNameNormalised)`),
//   loader: fn(item) => Array<LoadRow> (defaults to `loaderFactory(Model)`),
//   needs: ['otherSheetNames', 'thisOneNeeds'] (defaults to `[]`),
// }
//
// where interface LoadRow { model: string; values: object; }
//
// creating dependency cycles will (intentionally) crash the importer
"default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _loaders = require("./loaders");
const _default = {
    user: {},
    patient: {
        loader: _loaders.patientDataLoader,
        needs: [
            'user',
            'patientFieldDefinition'
        ]
    },
    facility: {},
    department: {
        needs: [
            'facility'
        ]
    },
    locationGroup: {
        needs: [
            'facility'
        ]
    },
    location: {
        needs: [
            'facility',
            'locationGroup'
        ]
    },
    certifiableVaccine: {},
    scheduledVaccine: {},
    administeredVaccine: {
        loader: _loaders.administeredVaccineLoader,
        needs: [
            'scheduledVaccine',
            'user',
            'location',
            'department'
        ]
    },
    labTestType: {},
    labTestPanel: {
        loader: _loaders.labTestPanelLoader,
        needs: [
            'labTestType'
        ]
    },
    invoiceProduct: {},
    role: {},
    permission: {
        loader: _loaders.permissionLoader,
        needs: [
            'role'
        ]
    },
    patientFieldDefinitionCategory: {},
    patientFieldDefinition: {
        loader: _loaders.patientFieldDefinitionLoader,
        needs: [
            'patientFieldDefinitionCategory'
        ]
    },
    imagingAreaExternalCode: {},
    translatedString: {
        loader: _loaders.translatedStringLoader
    },
    referenceDataRelation: {}
};

//# sourceMappingURL=dependencies.js.map