"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ChangelogNotesToEncounterHistory", {
    enumerable: true,
    get: function() {
        return ChangelogNotesToEncounterHistory;
    }
});
const _dataMigrations = require("@tamanu/shared/dataMigrations");
const _getChangelogToEncounterHistoryQuery = require("./getChangelogToEncounterHistoryQuery");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
const NOTE_SUB_QUERY = `
    select
        n.id,
        n.record_id,
        n.note_type,
        n.author_id as actor_id,
        n.date,
        n.content
    from notes n
    join batch_encounters e on n.record_id = e.id
    where note_type = 'system'
    and record_type = 'Encounter'
    order by n.record_id, n.date
`;
let ChangelogNotesToEncounterHistory = class ChangelogNotesToEncounterHistory extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return (0, _getChangelogToEncounterHistoryQuery.getChangelogToEncounterHistoryQuery)(NOTE_SUB_QUERY);
    }
    constructor(...args){
        super(...args);
        _define_property(this, "lastMaxId", '');
    }
};
_define_property(ChangelogNotesToEncounterHistory, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(ChangelogNotesToEncounterHistory, "defaultDelayMs", 50);

//# sourceMappingURL=ChangelogNotesToEncounterHistory.js.map