"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CovidClearanceCertificatePublisher", {
    enumerable: true,
    get: function() {
        return CovidClearanceCertificatePublisher;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _utils = require("@tamanu/shared/utils");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let CovidClearanceCertificatePublisher = class CovidClearanceCertificatePublisher extends _tasks.ScheduledTask {
    getName() {
        return 'CovidClearanceCertificatePublisher';
    }
    async run() {
        const { LabRequest, LabTest, CertificateNotification, Encounter } = this.models;
        const questionId = _config.default.questionCodeIds?.email;
        const labRequestsWhere = {
            ...await (0, _utils.getCovidClearanceCertificateFilter)(this.models),
            '$certificate_notification.id$': null
        };
        // Get lab requests that were sampled 13 days before the start
        // of today, and with configured lab test categories
        const clearedRequests = await LabRequest.findAll({
            where: labRequestsWhere,
            include: [
                {
                    model: LabTest,
                    as: 'tests',
                    required: true
                },
                {
                    model: CertificateNotification,
                    as: 'certificate_notification',
                    required: false,
                    where: {
                        type: _constants.COVID_19_CLEARANCE_CERTIFICATE,
                        created_by: this.getName()
                    }
                },
                {
                    model: Encounter,
                    as: 'encounter',
                    required: true
                }
            ]
        });
        for (const labRequest of clearedRequests){
            const emailAddress = await (0, _utils.getPatientSurveyResponseAnswer)(this.models, labRequest.encounter.patientId, questionId);
            await CertificateNotification.create({
                type: _constants.COVID_19_CLEARANCE_CERTIFICATE,
                createdBy: this.getName(),
                requiresSigning: false,
                patientId: labRequest.encounter.patientId,
                // If forward address is null, the communication service will
                // attempt to use the patient.email field
                forwardAddress: emailAddress,
                status: _constants.CERTIFICATE_NOTIFICATION_STATUSES.QUEUED,
                labRequestId: labRequest.id
            });
        }
    }
    constructor(context){
        const { schedule, jitterTime, enabled } = _config.default.schedules.covidClearanceCertificatePublisher;
        super(schedule, _logging.log, jitterTime, enabled);
        this.models = context.store.models;
    }
};

//# sourceMappingURL=CovidClearanceCertificatePublisher.js.map