"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePayment", {
    enumerable: true,
    get: function() {
        return InvoicePayment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _dateTimeTypes = require("./dateTimeTypes");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let InvoicePayment = class InvoicePayment extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _dateTimeTypes.dateType)('date', {
                allowNull: false
            }),
            receiptNumber: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            amount: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    /**
   *
   * @param {import('./')} models
   */ static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.hasOne(models.InvoicePatientPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'patientPayment'
        });
        this.hasOne(models.InvoiceInsurerPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'insurerPayment'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoices',
                'encounters'
            ])
        };
    }
    /**
   *
   * @param {import('./')} models
   */ static getListReferenceAssociations(models) {
        return [
            {
                model: models.InvoicePatientPayment,
                as: 'patientPayment',
                include: models.InvoicePatientPayment.getListReferenceAssociations(models)
            },
            {
                model: models.InvoiceInsurerPayment,
                as: 'insurerPayment',
                include: models.InvoiceInsurerPayment.getListReferenceAssociations(models)
            }
        ];
    }
};

//# sourceMappingURL=InvoicePayment.js.map