import React from 'react';
import { Box, Logo } from './Layout';
import { H1, H2 } from './Typography';
export const CovidLetterheadSection = ({ getLocalisation, logoSrc })=>{
    const title = getLocalisation('templates.letterhead.title');
    const subTitle = getLocalisation('templates.letterhead.subTitle');
    return /*#__PURE__*/ React.createElement(React.Fragment, null, logoSrc && /*#__PURE__*/ React.createElement(Logo, {
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(Box, {
        style: {
            maxWidth: 400,
            marginLeft: 'auto',
            marginRight: 'auto'
        }
    }, /*#__PURE__*/ React.createElement(H1, null, title), /*#__PURE__*/ React.createElement(H2, null, subTitle)));
};

//# sourceMappingURL=CovidLetterheadSection.js.map