import { SpanAttributes } from '@opentelemetry/api';
import { ExpressInstrumentationConfig } from './types';
import { ExpressLayerType } from './enums/ExpressLayerType';
import { ExpressLayer, PatchedRequest } from './internal-types';
/**
 * Store layers path in the request to be able to construct route later
 * @param request The request where
 * @param [value] the value to push into the array
 */
export declare const storeLayerPath: (request: PatchedRequest, value?: string | undefined) => void;
/**
 * Parse express layer context to retrieve a name and attributes.
 * @param layer Express layer
 * @param [layerPath] if present, the path on which the layer has been mounted
 */
export declare const getLayerMetadata: (layer: ExpressLayer, layerPath?: string | undefined) => {
    attributes: SpanAttributes;
    name: string;
};
/**
 * Check whether the given request is ignored by configuration
 * It will not re-throw exceptions from `list` provided by the client
 * @param constant e.g URL of request
 * @param [list] List of ignore patterns
 * @param [onException] callback for doing something when an exception has
 *     occurred
 */
export declare const isLayerIgnored: (name: string, type: ExpressLayerType, config?: ExpressInstrumentationConfig | undefined) => boolean;
//# sourceMappingURL=utils.d.ts.map