(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsOr = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"ଅ":[{},[0,1]],"ଆ":[{},[0,1]],"ଇ":[{},[0,1]],"ଈ":[{},[0,1]],"ଉ":[{},[0,1]],"ଊ":[{},[0,1]],"ଋ":[{},[0,1]],"ୠ":[{},[0,1]],"ଌ":[{},[0,1]],"ୡ":[{},[0,1]],"ଏ":[{},[0,1]],"ଐ":[{},[0,1]],"ଓ":[{},[0,1]],"ଔ":[{},[0,1]],"ା":[{},[0,1]],"ି":[{},[0,1]],"ୀ":[{},[0,1]],"ୁ":[{},[0,1]],"ୂ":[{},[0,1]],"ୃ":[{},[0,1]],"େ":[{},[0,1]],"ୈ":[{},[0,1]],"ୋ":[{},[0,1]],"ୌ":[{},[0,1]],"କ":[{},[1]],"ଖ":[{},[1]],"ଗ":[{},[1]],"ଘ":[{},[1]],"ଙ":[{},[1]],"ଚ":[{},[1]],"ଛ":[{},[1]],"ଜ":[{},[1]],"ଝ":[{},[1]],"ଞ":[{},[1]],"ଟ":[{},[1]],"ଠ":[{},[1]],"ଡ":[{},[1]],"ଢ":[{},[1]],"ଣ":[{},[1]],"ତ":[{},[1]],"ଥ":[{},[1]],"ଦ":[{},[1]],"ଧ":[{},[1]],"ନ":[{},[1]],"ପ":[{},[1]],"ଫ":[{},[1]],"ବ":[{},[1]],"ଭ":[{},[1]],"ମ":[{},[1]],"ଯ":[{},[1]],"ର":[{},[1]],"ଲ":[{},[1]],"ଳ":[{},[1]],"ଵ":[{},[1]],"ଶ":[{},[1]],"ଷ":[{},[1]],"ସ":[{},[1]],"ହ":[{},[1]],"ଂ":[{},[2,1]],"ଃ":[{},[2,1]],"ୗ":[{},[2,1]],"ଁ":[{},[2,1]],"୍":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
