"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "surveyResponse", {
    enumerable: true,
    get: function() {
        return surveyResponse;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _utilities = require("@tamanu/shared/reports/utilities");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const surveyResponse = _express.default.Router();
// also update getNameColumnForModel in /packages/facility-server/app/routes/apiv1/surveyResponse.js when this changes
function getNameColumnForModel(modelName) {
    switch(modelName){
        case 'User':
            return 'displayName';
        default:
            return 'name';
    }
}
// also update getDisplayNameForModel in /packages/mobile/App/ui/helpers/fields.ts when this changes
function getDisplayNameForModel(modelName, record) {
    const columnName = getNameColumnForModel(modelName);
    return record[columnName] || record.id;
}
surveyResponse.get('/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('read', 'SurveyResponse');
    const surveyResponseRecord = await models.SurveyResponse.findByPk(params.id);
    const survey = await surveyResponseRecord.getSurvey();
    req.checkPermission('read', survey);
    const components = await models.SurveyScreenComponent.getComponentsForSurvey(surveyResponseRecord.surveyId, {
        includeAllVitals: true
    });
    const answers = await models.SurveyResponseAnswer.findAll({
        where: {
            responseId: params.id
        }
    });
    const autocompleteComponentMap = (0, _utilities.getAutocompleteComponentMap)(components);
    // Transform Autocomplete answers from: { body: ReferenceData.id } to: { body: ReferenceData.name, originalBody: ReferenceData.id }
    const transformedAnswers = await Promise.all(answers.map(async (answer)=>{
        const componentConfig = autocompleteComponentMap.get(answer.dataValues.dataElementId);
        if (!componentConfig) {
            return answer;
        }
        const model = models[componentConfig.source];
        if (!model) {
            throw new Error('Survey is misconfigured: Question config did not specify a valid source');
        }
        const result = await model.findByPk(answer.dataValues.body);
        if (!result) {
            // If the answer is empty, return it as is rather than throwing an error
            if (answer.dataValues.body === '') {
                return answer;
            }
            if (componentConfig.source === 'ReferenceData') {
                throw new Error(`Selected answer ${componentConfig.source}[${answer.dataValues.body}] not found (check that the surveyquestion's source isn't ReferenceData for a Location, Facility, or Department)`);
            }
            throw new Error(`Selected answer ${componentConfig.source}[${answer.dataValues.body}] not found`);
        }
        const transformedAnswer = {
            ...answer.dataValues,
            originalBody: answer.dataValues.body,
            body: getDisplayNameForModel(componentConfig.source, result)
        };
        return transformedAnswer;
    }));
    res.send({
        ...surveyResponseRecord.forResponse(),
        components,
        answers: transformedAnswers
    });
}));
surveyResponse.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, body, db } = req;
    // Responses for the vitals survey will check against 'Vitals' create permissions
    // All others witll check against 'SurveyResponse' create permissions
    const noun = await models.Survey.getResponsePermissionCheck(body.surveyId);
    req.checkPermission('create', noun);
    const getDefaultId = async (type)=>models.SurveyResponseAnswer.getDefaultId(type);
    const updatedBody = {
        locationId: body.locationId || await getDefaultId('location'),
        departmentId: body.departmentId || await getDefaultId('department'),
        userId: req.user.id,
        ...body
    };
    const responseRecord = await db.transaction(async ()=>{
        return models.SurveyResponse.createWithAnswers(updatedBody);
    });
    res.send(responseRecord);
}));

//# sourceMappingURL=surveyResponse.js.map