"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "defineWebsocketService", {
    enumerable: true,
    get: function() {
        return defineWebsocketService;
    }
});
const _socketio = require("socket.io");
const _constants = require("@tamanu/constants");
const setupDatabaseNotificationForwarding = (pg, socketServer)=>{
    pg.on('notification', (message)=>{
        const { channel, payload } = message;
        if (channel === _constants.NOTIFY_CHANNELS.DATA_UPDATED) {
            const viewName = payload;
            socketServer.emit(`${_constants.WS_EVENT_NAMESPACES.DATA_UPDATED}:${viewName}`);
        }
    });
    pg.query(`LISTEN ${_constants.NOTIFY_CHANNELS.DATA_UPDATED}`);
};
const defineWebsocketService = (injector)=>{
    const socketServer = new _socketio.Server(injector.httpServer, {
        connectionStateRecovery: {
            skipMiddlewares: true,
            maxDisconnectionDuration: 120000
        },
        cors: {
            origin: '*',
            methods: [
                'GET',
                'POST'
            ]
        }
    });
    const getSocketServer = ()=>socketServer;
    setupDatabaseNotificationForwarding(injector.pg, socketServer);
    /**
   *
   * @param {string} eventName
   * @param  {...unknown} args
   * @returns
   */ const emit = (eventName, ...args)=>socketServer.emit(eventName, ...args);
    return {
        getSocketServer,
        emit
    };
};

//# sourceMappingURL=websocketService.js.map