"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "initDeviceId", {
    enumerable: true,
    get: function() {
        return initDeviceId;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _shortid = /*#__PURE__*/ _interop_require_default(require("shortid"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function initDeviceId(context) {
    const { LocalSystemFact } = context.models;
    let deviceId = await LocalSystemFact.get('deviceId');
    if (!deviceId) {
        deviceId = _config.default.deviceId ?? `facility-${(0, _shortid.default)()}`;
        await LocalSystemFact.set('deviceId', deviceId);
    } else if (_config.default.deviceId && deviceId !== _config.default.deviceId) {
        throw new Error(`Device ID mismatch: ${deviceId} (from database) vs ${_config.default.deviceId} (from config)`);
    }
    // eslint-disable-next-line require-atomic-updates
    context.deviceId = deviceId;
}

//# sourceMappingURL=initDeviceId.js.map