"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "buildSettings", {
    enumerable: true,
    get: function() {
        return buildSettings;
    }
});
const _constants = require("@tamanu/constants");
const _lodash = require("lodash");
const _defaults = require("../defaults");
const _SettingsDBReader = require("./readers/SettingsDBReader");
const _SettingsJSONReader = require("./readers/SettingsJSONReader");
function getReaders(models, facilityId) {
    return facilityId ? [
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.FACILITY, facilityId),
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.GLOBAL),
        new _SettingsJSONReader.SettingsJSONReader(_defaults.facilityDefaults),
        new _SettingsJSONReader.SettingsJSONReader(_defaults.globalDefaults)
    ] : [
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.CENTRAL),
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.GLOBAL),
        new _SettingsJSONReader.SettingsJSONReader(_defaults.centralDefaults),
        new _SettingsJSONReader.SettingsJSONReader(_defaults.globalDefaults)
    ];
}
async function buildSettings(models, facilityId) {
    const readers = getReaders(models, facilityId);
    let settings = {};
    for (const reader of readers){
        const value = await reader.getSettings();
        if (value) {
            // Prioritize the previous one
            settings = (0, _lodash.merge)(value, settings);
        }
    }
    return settings;
}

//# sourceMappingURL=buildSettings.js.map