function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { Reader } from './Reader';
export class SettingsJSONReader extends Reader {
    async getSettings() {
        return this.jsonConfig;
    }
    constructor(jsonConfig){
        super();
        _define_property(this, "jsonConfig", void 0);
        this.jsonConfig = jsonConfig;
    }
}

//# sourceMappingURL=SettingsJSONReader.js.map