"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CursorDataMigration: function() {
        return _CursorDataMigration.CursorDataMigration;
    },
    DataMigration: function() {
        return _DataMigration.DataMigration;
    },
    disableSyncTrigger: function() {
        return disableSyncTrigger;
    },
    isSyncTriggerDisabled: function() {
        return isSyncTriggerDisabled;
    }
});
const _DataMigration = require("./DataMigration");
const _CursorDataMigration = require("./CursorDataMigration");
const disableSyncTrigger = async (sequelize, callback)=>{
    const { LocalSystemFact } = sequelize.models;
    await LocalSystemFact.set('syncTrigger', 'disabled');
    await callback();
    await LocalSystemFact.set('syncTrigger', 'enabled');
};
const isSyncTriggerDisabled = async (sequelize)=>{
    const state = await sequelize.models.LocalSystemFact.get('syncTrigger');
    return state === 'disabled';
};

//# sourceMappingURL=index.js.map