"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DebugLog", {
    enumerable: true,
    get: function() {
        return DebugLog;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let DebugLog = class DebugLog extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            type: _sequelize.DataTypes.STRING,
            info: {
                type: _sequelize.DataTypes.JSON
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs',
            timestamps: false
        });
    }
    async addInfo(info) {
        await this.update({
            info: {
                ...this.info,
                ...info
            }
        });
    }
};

//# sourceMappingURL=DebugLog.js.map