"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterMedication", {
    enumerable: true,
    get: function() {
        return EncounterMedication;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let EncounterMedication = class EncounterMedication extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _dateTimeTypes.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            endDate: (0, _dateTimeTypes.dateTimeType)('endDate'),
            prescription: _sequelize.Sequelize.STRING,
            note: _sequelize.Sequelize.STRING,
            indication: _sequelize.Sequelize.STRING,
            route: _sequelize.Sequelize.STRING,
            qtyMorning: _sequelize.Sequelize.INTEGER,
            qtyLunch: _sequelize.Sequelize.INTEGER,
            qtyEvening: _sequelize.Sequelize.INTEGER,
            qtyNight: _sequelize.Sequelize.INTEGER,
            quantity: _sequelize.Sequelize.INTEGER,
            discontinued: _sequelize.Sequelize.BOOLEAN,
            discontinuedDate: _sequelize.Sequelize.STRING,
            discontinuingReason: _sequelize.Sequelize.STRING,
            repeats: _sequelize.Sequelize.INTEGER,
            isDischarge: {
                type: _sequelize.Sequelize.BOOLEAN,
                allowNull: false,
                defaultValue: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveMedication () {
                    if (!this.medicationId) {
                        throw new Error('An encounter medication must be attached to a medication.');
                    }
                },
                mustHaveEncounter () {
                    if (!this.encounterId) {
                        throw new Error('An encounter medication must be attached to an encounter.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'prescriberId',
            as: 'prescriber'
        });
        this.belongsTo(models.User, {
            foreignKey: 'discontinuingClinicianId',
            as: 'discontinuingClinician'
        });
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'medicationId',
            as: 'Medication'
        });
    }
    static getListReferenceAssociations() {
        return [
            'Medication',
            'encounter',
            'prescriber',
            'discontinuingClinician'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=EncounterMedication.js.map