"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceItem", {
    enumerable: true,
    get: function() {
        return InvoiceItem;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let InvoiceItem = class InvoiceItem extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            orderDate: (0, _dateTimeTypes.dateType)('orderDate', {
                allowNull: false
            }),
            productId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            quantity: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            note: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            sourceId: {
                type: _sequelize.DataTypes.UUID,
                allowNull: true
            },
            productName: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            productPrice: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            productCode: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            productDiscountable: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    /**
   *
   * @param {import('./')} models
   */ static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.hasOne(models.InvoiceItemDiscount, {
            foreignKey: 'invoiceItemId',
            as: 'discount'
        });
        this.belongsTo(models.User, {
            foreignKey: 'orderedByUserId',
            as: 'orderedByUser'
        });
        this.belongsTo(models.InvoiceProduct, {
            foreignKey: 'productId',
            as: 'product'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoices',
                'encounters'
            ])
        };
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.InvoiceProduct,
                as: 'product',
                include: [
                    {
                        model: models.ReferenceData,
                        as: 'referenceData',
                        attributes: [
                            'code',
                            'type'
                        ]
                    },
                    {
                        model: models.LabTestType,
                        as: 'labTestType',
                        attributes: [
                            'code'
                        ]
                    }
                ]
            },
            {
                model: models.User,
                as: 'orderedByUser',
                attributes: [
                    'displayName'
                ]
            },
            {
                model: models.InvoiceItemDiscount,
                as: 'discount'
            }
        ];
    }
};

//# sourceMappingURL=InvoiceItem.js.map