"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ScheduledVaccine", {
    enumerable: true,
    get: function() {
        return ScheduledVaccine;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ScheduledVaccine = class ScheduledVaccine extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            category: _sequelize.Sequelize.STRING,
            label: _sequelize.Sequelize.STRING,
            doseLabel: _sequelize.Sequelize.STRING,
            weeksFromBirthDue: _sequelize.Sequelize.INTEGER,
            weeksFromLastVaccinationDue: _sequelize.Sequelize.INTEGER,
            index: _sequelize.Sequelize.INTEGER,
            hideFromCertificate: {
                type: _sequelize.Sequelize.BOOLEAN,
                defaultValue: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            },
            sortIndex: {
                type: _sequelize.Sequelize.INTEGER,
                defaultValue: 0
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static getListReferenceAssociations() {
        return [
            'vaccine'
        ];
    }
    static async getOtherCategoryScheduledVaccine() {
        // Should only contain 1 scheduled vaccine with Other category per environment
        return this.findOne({
            where: {
                category: _constants.VACCINE_CATEGORIES.OTHER
            }
        });
    }
    static initRelations(models) {
        // vaccine is of type drug
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'vaccineId',
            as: 'vaccine'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ScheduledVaccine.js.map