"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirEncounter", {
    enumerable: true,
    get: function() {
        return FhirEncounter;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
const _getQueryToFilterUpstream = require("./getQueryToFilterUpstream");
const _fhirTypes = require("../../../services/fhirTypes");
let FhirEncounter = class FhirEncounter extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            status: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            class: _sequelize.DataTypes.JSONB,
            subject: _sequelize.DataTypes.JSONB,
            actualPeriod: _sequelize.DataTypes.JSONB,
            location: _sequelize.DataTypes.JSONB,
            serviceProvider: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.Encounter
        ];
        this.upstreams = [
            models.Encounter,
            models.Discharge,
            models.Patient,
            models.Location,
            models.LocationGroup
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromEncounters)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { Encounter } = this.sequelize.models;
        if (upstreamTable === Encounter.tableName) {
            return (0, _getQueryToFilterUpstream.filterFromEncounters)(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    asFhir() {
        const resource = super.asFhir();
        const { FhirPatient } = this.sequelize.models;
        // Exclude unresolved upstream if it remains in the materialised data.
        if (resource.subject.type === _fhirTypes.FhirReference.unresolvedReferenceType(FhirPatient)) {
            delete resource.subject;
        }
        return resource;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirEncounter.js.map