"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getValues", {
    enumerable: true,
    get: function() {
        return getValues;
    }
});
const _fhirTypes = require("../../../services/fhirTypes");
const _constants = require("@tamanu/constants");
async function getValues(upstream, models) {
    const { Facility } = models;
    if (upstream instanceof Facility) return getValuesFromFacility(upstream);
    throw new Error(`Invalid upstream type for organization ${upstream.constructor.name}`);
}
async function getValuesFromFacility(upstream) {
    return {
        lastUpdated: new Date(),
        identifier: [
            new _fhirTypes.FhirIdentifier({
                value: upstream.code
            })
        ],
        name: upstream.name,
        active: getActive(upstream),
        resolved: true
    };
}
function getActive(facility) {
    if (facility === null) return null;
    return facility.visibilityStatus === _constants.VISIBILITY_STATUSES.CURRENT;
}

//# sourceMappingURL=getValues.js.map