"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getModelsForDirection", {
    enumerable: true,
    get: function() {
        return getModelsForDirection;
    }
});
const _constants = require("@tamanu/constants");
const getModelsForDirection = (models, direction)=>{
    const filter = (modelSyncDirection)=>{
        if (direction === _constants.SYNC_DIRECTIONS.DO_NOT_SYNC) {
            return modelSyncDirection === _constants.SYNC_DIRECTIONS.DO_NOT_SYNC;
        }
        // other sync directions include bidirectional models
        return [
            direction,
            _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        ].includes(modelSyncDirection);
    };
    return Object.fromEntries(Object.entries(models).filter(([, model])=>filter(model.syncDirection)));
};

//# sourceMappingURL=getModelsForDirection.js.map