"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getAgeDurationFromDate: function() {
        return getAgeDurationFromDate;
    },
    getAgeFromDate: function() {
        return getAgeFromDate;
    },
    getDisplayAge: function() {
        return getDisplayAge;
    }
});
const _datefns = require("date-fns");
const _dateTime = require("./dateTime");
function getAgeFromDate(date) {
    return (0, _datefns.differenceInYears)(new Date(), new Date(date));
}
const getDifferenceFnByUnit = {
    years: _datefns.differenceInYears,
    months: _datefns.differenceInMonths,
    weeks: _datefns.differenceInWeeks,
    days: _datefns.differenceInDays
};
function getAgeDurationFromDate(date) {
    return (0, _datefns.intervalToDuration)({
        start: (0, _dateTime.parseDate)(date),
        end: new Date()
    });
}
const comparators = {
    '>': (left, right)=>left > right,
    '<': (left, right)=>left < right,
    '>=': (left, right)=>left >= right,
    '<=': (left, right)=>left <= right
};
function compareDate(leftDate, operator, rightDate, exclusive) {
    let comparator = operator;
    if (!exclusive) {
        comparator += '=';
    }
    const comparatorFn = comparators[comparator];
    return comparatorFn(leftDate, rightDate);
}
function ageIsWithinRange(birthDate, range) {
    const { min = {}, max = {} } = range;
    const { duration: minDuration, exclusive: minExclusive } = min;
    const { duration: maxDuration, exclusive: maxExclusive } = max;
    const minDate = minDuration ? (0, _datefns.startOfDay)((0, _datefns.add)(birthDate, minDuration)) : -Infinity;
    const maxDate = maxDuration ? (0, _datefns.startOfDay)((0, _datefns.add)(birthDate, maxDuration)) : Infinity;
    const now = (0, _datefns.startOfDay)(new Date());
    return (!minDate || compareDate(minDate, '<', now, minExclusive)) && (!maxDate || compareDate(now, '<', maxDate, maxExclusive));
}
function getDisplayAge(dateOfBirth, ageDisplayFormat) {
    if (!ageDisplayFormat || !(0, _dateTime.isISOString)(dateOfBirth)) {
        return '';
    }
    const ageDuration = getAgeDurationFromDate(dateOfBirth);
    const birthDate = (0, _dateTime.parseDate)(dateOfBirth);
    for (const displayFormat of ageDisplayFormat){
        const { as, range } = displayFormat;
        if (ageIsWithinRange(birthDate, range)) {
            const differenceFn = getDifferenceFnByUnit[as];
            const value = differenceFn(new Date(), birthDate);
            const unit = as.slice(0, -1); // slice off the s
            return `${value} ${unit}${value === 1 ? '' : 's'}`;
        }
    }
    return (0, _datefns.formatDuration)(ageDuration, {
        format: [
            'years'
        ]
    });
}

//# sourceMappingURL=date.js.map