"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FAKE_UUID_PATTERN: function() {
        return FAKE_UUID_PATTERN;
    },
    fakeUUID: function() {
        return fakeUUID;
    },
    generateId: function() {
        return generateId;
    },
    isGeneratedDisplayId: function() {
        return isGeneratedDisplayId;
    }
});
const _crypto = /*#__PURE__*/ _interop_require_default(require("crypto"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const generators = {
    A: ()=>String.fromCharCode(65 + Math.floor(Math.random() * 26)),
    '0': ()=>Math.floor(Math.random() * 10).toFixed(0)
};
function createIdGenerator(format) {
    const generatorPattern = Array.from(format).map((char)=>generators[char] || (()=>''));
    return ()=>generatorPattern.map((generator)=>generator()).join('');
}
const DISPLAY_ID_FORMAT = 'AAAA000000';
const generateId = createIdGenerator(DISPLAY_ID_FORMAT);
const isGeneratedDisplayId = (displayId)=>{
    if (DISPLAY_ID_FORMAT !== 'AAAA000000') return false;
    return /^[A-Z]{4}\d{6}$/.test(displayId);
};
function fakeUUID() {
    return _crypto.default.randomUUID().replace(/(.{8}-.{4})-.{4}-(.+)/, '$1-0000-$2');
}
const FAKE_UUID_PATTERN = '________-____-0000-____-____________';

//# sourceMappingURL=generateId.js.map