"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CertificateTypes: function() {
        return CertificateTypes;
    },
    CovidLabCertificate: function() {
        return CovidLabCertificate;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _replaceInTemplate = require("../replaceInTemplate");
const _Table = require("./Table");
const _Layout = require("./Layout");
const _CovidLetterheadSection = require("./CovidLetterheadSection");
const _CovidPatientDetailsSection = require("./CovidPatientDetailsSection");
const _SigningSection = require("./SigningSection");
const _Typography = require("./Typography");
const _labRequestAccessors = require("./labRequestAccessors");
const _getDisplayDate = require("./getDisplayDate");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const columns = [
    {
        key: 'date-of-swab',
        title: 'Date of swab',
        accessor: _labRequestAccessors.getDateOfSwab
    },
    {
        key: 'time-of-swab',
        title: 'Time of swab',
        accessor: _labRequestAccessors.getTimeOfSwab
    },
    {
        key: 'date-of-test',
        title: 'Date of test',
        accessor: _labRequestAccessors.getCompletedDate
    },
    {
        key: 'laboratory',
        title: 'Laboratory',
        accessor: _labRequestAccessors.getLaboratory
    },
    {
        key: 'requestId',
        title: 'Request ID',
        accessor: _labRequestAccessors.getRequestId
    },
    {
        key: 'method',
        title: 'Method',
        accessor: _labRequestAccessors.getLabMethod
    },
    {
        key: 'result',
        title: 'Result',
        accessor: ({ result })=>result
    },
    {
        key: 'specimenType',
        title: 'Specimen type',
        accessor: ({ labTestType })=>(labTestType || {}).name || 'Unknown'
    }
];
const CertificateTypes = {
    test: 'test',
    clearance: 'clearance'
};
const CertificateTitle = {
    test: 'Covid-19 Test History',
    clearance: 'Covid-19 Clearance Certificate'
};
const getCertificateRemark = (patient, getLocalisation)=>({
        test: '',
        clearance: (0, _replaceInTemplate.replaceInTemplate)(getLocalisation('templates.covidTestCertificate.clearanceCertRemark') ?? '', patient)
    });
const CovidLabCertificateComponent = ({ patient, labs, signingSrc, watermarkSrc, vdsSrc, logoSrc, getLocalisation, printedBy, certType })=>/*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, watermarkSrc && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermarkSrc
    }), /*#__PURE__*/ _react.default.createElement(_CovidLetterheadSection.CovidLetterheadSection, {
        getLocalisation: getLocalisation,
        logoSrc: logoSrc
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 0
    }, /*#__PURE__*/ _react.default.createElement(_Typography.H3, null, CertificateTitle[certType] || ''), /*#__PURE__*/ _react.default.createElement(_CovidPatientDetailsSection.CovidPatientDetailsSection, {
        patient: patient,
        vdsSrc: vdsSrc,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 30
    }, /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        data: labs,
        columns: columns,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(_Typography.P, null, getCertificateRemark(patient, getLocalisation)[certType] || ''), /*#__PURE__*/ _react.default.createElement(_Layout.Box, null), /*#__PURE__*/ _react.default.createElement(_Layout.Box, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Printed by: ", printedBy)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, null, "Printing date: ", (0, _getDisplayDate.getDisplayDate)(undefined, undefined, getLocalisation))))), /*#__PURE__*/ _react.default.createElement(_SigningSection.SigningSection, {
        signingSrc: signingSrc
    })));
const CovidLabCertificate = (0, _languageContext.withLanguageContext)(CovidLabCertificateComponent);

//# sourceMappingURL=CovidLabCertificate.js.map