"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterDetailsExtended", {
    enumerable: true,
    get: function() {
        return EncounterDetailsExtended;
    }
});
const _DataSection = require("./DataSection");
const _Layout = require("../Layout");
const _DataItem = require("./DataItem");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _dateTime = require("../../dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const EncounterDetailsExtended = ({ encounter, discharge, clinicianText })=>{
    const { location, examiner, department, startDate, endDate, reasonForEncounter } = encounter;
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: "Encounter details",
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Facility",
        value: location.facility.name,
        key: "facility"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: `Supervising ${clinicianText.toLowerCase()}`,
        value: examiner.displayName,
        key: "supervisingClinician"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: `Discharging ${clinicianText.toLowerCase()}`,
        value: discharge?.discharger?.displayName,
        key: "dischargingClinician"
    }), discharge?.disposition?.name && /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Discharge disposition",
        value: discharge?.disposition?.name,
        key: "dischargeDisposition"
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Department",
        value: department.name,
        key: "department"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date of admission",
        value: (0, _dateTime.formatShort)(startDate),
        key: "dateOfAdmission"
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date of discharge",
        value: (0, _dateTime.formatShort)(endDate),
        key: "dateOfDischarge"
    })), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Reason for encounter",
        value: reasonForEncounter,
        key: "reasonForEncounter"
    }));
};

//# sourceMappingURL=EncounterDetailsExtended.js.map