"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientDetails", {
    enumerable: true,
    get: function() {
        return PatientDetails;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataSection = require("./DataSection");
const _Layout = require("../Layout");
const _patientAccessors = require("../../patientAccessors");
const _renderDataItems = require("./renderDataItems");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PATIENT_FIELDS = {
    leftCol: [
        {
            key: 'firstName',
            label: 'First name'
        },
        {
            key: 'lastName',
            label: 'Last name'
        },
        {
            key: 'dateOfBirth',
            label: 'DOB',
            accessor: _patientAccessors.getDOBWithAge
        }
    ],
    rightCol: [
        {
            key: 'displayId',
            label: 'Patient ID'
        },
        {
            key: 'sex',
            label: 'Sex',
            accessor: _patientAccessors.getSex
        },
        {
            key: 'villageName',
            label: 'Village',
            accessor: _patientAccessors.getVillageName
        }
    ]
};
const PatientDetails = ({ patient, getLocalisation })=>{
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: "Patient details"
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.leftCol, patient, getLocalisation)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.rightCol, patient, getLocalisation)));
};

//# sourceMappingURL=PatientDetails.js.map