"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    camelify: function() {
        return camelify;
    },
    deepRenameObjectKeys: function() {
        return deepRenameObjectKeys;
    },
    renameObjectKeys: function() {
        return renameObjectKeys;
    }
});
const _lodash = require("lodash");
function camelify(string) {
    const [initial, ...subsequent] = string.split('_');
    const uppercased = subsequent.filter((x)=>x).map((s)=>s[0].toUpperCase() + s.slice(1));
    return [
        initial,
        ...uppercased
    ].join('');
}
function renameObjectKeys(baseObject) {
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: baseObject[currentKey]
        }), {});
}
function deepRenameObjectKeys(baseObject) {
    if (!(0, _lodash.isPlainObject)(baseObject)) return baseObject;
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: deepRenameObjectKeys(baseObject[currentKey])
        }), {});
}

//# sourceMappingURL=renameObjectKeys.js.map