import React from 'react';
import { Document } from '@react-pdf/renderer';
import { Box, styles } from '../patientCertificates/Layout';
import { HandoverHeaderSection } from './HandoverHeaderSection';
import { HandoverPatient } from './HandoverPatient';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
const HandoverNotesPDFComponent = ({ handoverNotes = [], locationGroupName, logoSrc, getLocalisation, letterheadConfig })=>/*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, /*#__PURE__*/ React.createElement(HandoverHeaderSection, {
        letterheadConfig: letterheadConfig,
        locationGroupName: locationGroupName,
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(Box, {
        mb: 0
    }, handoverNotes.map(({ patient, diagnosis, notes, location, createdAt, isEdited, arrivalDate })=>/*#__PURE__*/ React.createElement(HandoverPatient, {
            key: `patient-notes-${patient.displayId}`,
            patient: patient,
            location: location,
            createdAt: createdAt,
            diagnosis: diagnosis,
            arrivalDate: arrivalDate,
            notes: notes,
            isEdited: isEdited,
            getLocalisation: getLocalisation
        })))));
export const HandoverNotesPDF = withLanguageContext(HandoverNotesPDFComponent);

//# sourceMappingURL=HandoverNotesPDF.js.map