import { StyleSheet, View } from '@react-pdf/renderer';
import React from 'react';
import { formatShort, getCurrentDateString } from '../../dateTime';
import { Text } from '../../pdf/Text';
const styles = StyleSheet.create({
    footer: {
        position: 'absolute',
        flexDirection: 'row',
        justifyContent: 'space-between',
        bottom: 25,
        left: 50,
        right: 50,
        color: '#888888',
        borderTop: '1px solid #888888',
        paddingTop: 2
    },
    footerLeftContent: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    footerRightContent: {
        flexDirection: 'row',
        textAlign: 'right'
    },
    labelText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica-Bold'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica'
    }
});
const LabelText = ({ children, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        style: styles.labelText,
        ...props
    }, children);
const ValueText = ({ children, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        style: styles.valueText,
        ...props
    }, children);
export const Footer = ({ printDate, printFacility, printedBy, style })=>{
    return /*#__PURE__*/ React.createElement(View, {
        style: [
            styles.footer,
            style
        ],
        fixed: true
    }, /*#__PURE__*/ React.createElement(View, {
        style: styles.footerLeftContent
    }, /*#__PURE__*/ React.createElement(LabelText, null, "Print date: "), /*#__PURE__*/ React.createElement(ValueText, null, formatShort(printDate || getCurrentDateString())), printFacility && /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(ValueText, null, " | "), /*#__PURE__*/ React.createElement(LabelText, null, "Print facility: "), /*#__PURE__*/ React.createElement(ValueText, null, printFacility)), printedBy && /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(ValueText, null, " | "), /*#__PURE__*/ React.createElement(LabelText, null, "Printed by: "), /*#__PURE__*/ React.createElement(ValueText, null, printedBy))), /*#__PURE__*/ React.createElement(View, {
        style: styles.footerRightContent
    }, /*#__PURE__*/ React.createElement(Text, {
        style: styles.valueText,
        render: ({ pageNumber, totalPages })=>`${pageNumber} of ${totalPages}`
    })));
};

//# sourceMappingURL=Footer.js.map