(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsKa = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"ა":[{"ვ":[{"რ":[{"წ":[{"ყ":[{"ა":[{},[0,0,4]]}]}]}]}],"ი":[{"ა":[{},[0,0,2]]}]}],"ე":[{"რ":[{"თ":[{"ხ":[{},[0,0,2]]}],"ტ":[{},[0,0,2]]}]}],"ი":[{"რ":[{"ტ":[{},[0,0,2]]}]}],"უ":[{"რ":[{"ტ":[{},[0,0,2]]}],"ფ":[{"რ":[{},[0,0,0,2]]}]}],"ფ":[{"რ":[{},[0,0,2]]}]}],"ა":[{"ა":[{},[0,1]],"ბ":[{"ლ":[{"დ":[{},[0,0,3]]}],"ნ":[{"ვ":[{},[0,0,3]]}],"რ":[{"კ":[{},[0,0,3]],"წ":[{},[0,0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}]},[0,1]],"გ":[{"გ":[{"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]]}],"ვ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"კ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ქ":[{},[0,0,3]],"ყ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ჩ":[{},[0,0,3]],"ც":[{},[0,0,3]],"ძ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ჭ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ზ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ლ":[{},[0,2,1]],"მ":[{"ნ":[{},[0,0,3]]},[0,2,1]],"რ":[{"ჩ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ი":[{},[0,0,3]]},[0,2]],"ც":[{"დ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"ს":[{},[0,0,3]]}]},[0,1]],"დ":[{"გ":[{"ნ":[{},[0,0,3]]}],"ზ":[{},[0,2,1]],"ლ":[{"მ":[{},[0,0,3]],"ფ":[{},[0,0,3]]}],"მ":[{"ყ":[{},[0,0,3]]}],"ნ":[{},[0,2,1]]},[0,1]],"ე":[{},[0,1]],"ვ":[{"ბ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"ზ":[{"ვ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"თ":[{"ბ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"კ":[{"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"მ":[{"დ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ნ":[{"დ":[{},[0,0,3]],"ძ":[{},[0,0,3]]}],"რ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ჩ":[{},[0,0,3]],"ც":[{},[0,0,3]],"წ":[{},[0,0,3]]}],"ს":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ძ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ზ":[{"რ":[{"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]]}]},[0,1]],"თ":[{"ა":[{"ს":[{},[1]]}],"გ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2,1]],"კ":[{"ვ":[{},[0,0,3]]}],"ლ":[{},[0,2,1]],"მ":[{"ფ":[{},[0,0,3]],"ყ":[{},[0,0,3]]}],"რ":[{"გ":[{},[0,0,3]]}],"ქ":[{"ო":[{},[0,3,2]]}]},[0,1]],"ი":[{},[0,1]],"კ":[{"ა":[{"რ":[{"გ":[{"ს":[{".":[{},[0,0,0,0,4]]}]}]}]}],"ბ":[{"ე":[{},[0,0,3]]},[0,2]],"დ":[{},[0,0,1]],"ვ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]]}],"რ":[{"თ":[{},[0,0,3]]}]},[0,1]],"ლ":[{"გ":[{"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]]}],"დ":[{"შ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]]}],"მ":[{"დ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ტ":[{"ბ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ღ":[{"რ":[{},[0,0,3]]}],"ყ":[{"ზ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ც":[{"რ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}]},[0,1]],"მ":[{"ბ":[{"ა":[{"ვ":[{"ი":[{".":[{},[2]]}]}]}],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"გ":[{"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"ვ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]]}],"ზ":[{"რ":[{},[0,0,3]]}],"თ":[{"რ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"ზ":[{},[0,0,3]]}],"ნ":[{"თ":[{},[0,0,3]]}],"პ":[{"ლ":[{},[0,0,3]]}],"რ":[{"გ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ღ":[{},[0,0,3]],"ჩ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ს":[{"გ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ჭ":[{},[0,0,3]],"ხ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ფ":[{"ლ":[{},[0,0,3]],"ს":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]],"კ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ნ":[{"გ":[{"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ვ":[{"თ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ც":[{},[0,0,3]]}],"ზ":[{"რ":[{},[0,0,3]]}],"თ":[{"რ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"კ":[{"მ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"მ":[{"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ხ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]],"მ":[{},[0,0,3]],"პ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ც":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"ყ":[{"რ":[{},[0,0,3]]}],"შ":[{"ტ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჭ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჯ":[{"გ":[{},[0,0,3]],"დ":[{},[0,0,3]]}]},[0,1]],"ო":[{},[0,1]],"პ":[{},[0,1]],"ჟ":[{"რ":[{"ჟ":[{},[0,0,3]]}],"ღ":[{},[0,2]]},[0,1]],"რ":[{"ა":[{"ხ":[{"ვ":[{},[0,0,0,0,2]]}]}],"ბ":[{"დ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"გ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ძ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ე":[{"რ":[{},[0,2,1]]}],"ვ":[{"ლ":[{},[0,0,3]],"ყ":[{},[0,0,3]],"წ":[{},[0,0,3]]}],"ზ":[{"ნ":[{},[0,0,3]]}],"თ":[{"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"ქ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"მ":[{"თ":[{},[0,0,3]],"ყ":[{},[0,0,3]]}],"ს":[{"დ":[{},[0,0,3]],"კ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ფ":[{"ლ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]]},[0,2,1]],"ხ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}]},[0,1]],"ს":[{"ა":[{"ს":[{"ი":[{},[0,0,1]]}],"ხ":[{"ლ":[{"ს":[{".":[{},[0,0,0,0,4]]}]}]}]}],"გ":[{"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ე":[{"ქ":[{},[0,0,1]]}],"ვ":[{"თ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"კ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"მ":[{"ე":[{},[0,0,3]]}],"ნ":[{},[0,2,1]],"პ":[{"შ":[{},[0,0,3]]}],"რ":[{"ვ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ს":[{"თ":[{},[0,0,3]]}],"ტ":[{"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{"ტ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}]},[0,1]],"ტ":[{"ვ":[{"რ":[{},[0,0,3]]},[0,0,1]],"კ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2,1]],"რ":[{"ლ":[{},[0,0,3]],"ფ":[{},[0,0,3]],"შ":[{},[0,0,3]]},[0,0,1]],"ს":[{"კ":[{},[0,0,3]]}],"ფ":[{"ო":[{},[0,0,3]]},[0,2]],"შ":[{"ი":[{},[0,0,3]]},[0,2]]},[0,1]],"უ":[{},[0,1]],"ფ":[{"თ":[{"რ":[{},[0,0,3]]}],"ლ":[{"წ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}]},[0,1]],"ქ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]},[0,0,1]],"მ":[{"ნ":[{},[0,0,3]]}],"რ":[{"ნ":[{},[0,0,3]]}],"ტ":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]]}]}],"ღ":[{"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]],"შ":[{},[0,0,3]]},[0,0,1]],"ზ":[{"რ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"მ":[{"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"კ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ძ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"რ":[{"მ":[{},[0,0,3]],"ღ":[{},[0,0,3]]}],"ს":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ფ":[{"რ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}]},[0,1]],"ყ":[{"დ":[{"რ":[{},[0,0,3]]},[0,0,1]],"ვ":[{"ზ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]]},[0,0,1]]},[0,1]],"შ":[{"ვ":[{"რ":[{},[0,0,3]]}],"ზ":[{},[0,2]],"ლ":[{"ზ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}],"ფ":[{"ა":[{},[0,0,3]],"ო":[{},[0,0,3]]},[0,2]]},[0,1]],"ჩ":[{"ნ":[{"დ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ც":[{"ვ":[{"ლ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]]}],"მ":[{"ლ":[{},[0,0,3]]}],"ქ":[{"ე":[{},[0,0,3]],"ვ":[{},[0,0,3]]},[0,2,1]]},[0,1]],"ძ":[{"ა":[{"რ":[{"ც":[{"ვ":[{".":[{},[0,0,0,0,4]]}]}]}]}],"ვ":[{"რ":[{},[0,0,3]]}],"რ":[{"წ":[{},[0,0,3]]}]},[0,1]],"წ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{},[0,2]],"მ":[{"ყ":[{},[0,0,3]]},[0,2]],"რ":[{"თ":[{},[0,0,3]]},[0,2,1]]},[0,1]],"ჭ":[{"ვ":[{"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"მ":[{"ლ":[{},[0,0,3]]}]},[0,1]],"ხ":[{"ვ":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,0,1]],"ზ":[{},[0,0,1]],"ლ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"მ":[{},[0,2,1]],"რ":[{"ჩ":[{},[0,0,3]],"წ":[{},[0,0,3]]},[0,0,1]],"ს":[{"რ":[{},[0,0,3]]}],"ტ":[{"ზ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}]},[0,1]],"ჯ":[{"ვ":[{},[0,2,1]],"მ":[{},[0,2]]},[0,1]],"ჰ":[{"კ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"ს":[{},[0,0,3]]}]}]}],"ბ":[{"ა":[{"თ":[{"ვ":[{},[0,0,3,2]]}]},[1]],"გ":[{},[2,1]],"დ":[{},[2,1]],"ე":[{},[1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{},[2,1,2]],"ი":[{},[1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{},[2,1,2]],"ო":[{"თ":[{"ქ":[{},[0,0,3,2]]}]},[1]],"ჟ":[{},[2,1]],"რ":[{},[2,1,2]],"ს":[{},[2,1,2]],"უ":[{},[1]],"ქ":[{},[2,1]],"ღ":[{},[1,0,2]],"შ":[{},[2,1]],"ჩ":[{},[2,1]],"ც":[{},[2,1]],"ჭ":[{},[2,1]],"ჯ":[{},[2,1]]}],"გ":[{"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{},[2,1]],"ვ":[{"თ":[{"ა":[{},[0,3]]}]},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{},[2,1,2]],"ი":[{"ე":[{"რ":[{"თ":[{"ს":[{".":[{},[0,0,0,0,4]]}]}]}]}],"მ":[{"ო":[{},[0,0,2]]}]}],"კ":[{},[2,1,2]],"ლ":[{"ე":[{"ჯ":[{"ვ":[{},[3]]}]},[0,1]]}],"მ":[{},[0,0,2]],"ნ":[{},[2,1]],"პ":[{},[2,1]],"ჟ":[{},[2,1]],"რ":[{},[2,1,2]],"ს":[{},[2,1,2]],"ტ":[{},[2,1]],"უ":[{},[1]],"ღ":[{},[2,1]],"ყ":[{},[2,1,2]],"შ":[{"რ":[{},[0,1]]},[0,2,2]],"ჩ":[{},[2,1]],"ც":[{},[2,1,2]],"ძ":[{},[2,1,2]],"წ":[{},[2,1]],"ჭ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1]]}],"დ":[{"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{},[2,1]],"ე":[{"რ":[{"ი":[{},[0,0,3]]}],"ღ":[{"რ":[{},[0,0,3]]},[0,0,0,2]]}],"ვ":[{},[2,1]],"თ":[{},[2,1,2]],"ი":[{"ღ":[{"ბ":[{"ა":[{"ლ":[{"მ":[{},[2]]}]}],"ლ":[{"ი":[{"ს":[{},[2]]}]}]}]}]}],"კ":[{},[2,1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{"ა":[{},[0,1]]},[1]],"პ":[{},[2,1]],"ჟ":[{},[2,1]],"რ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"ს":[{},[2,2,2]],"ფ":[{},[0,2]],"ქ":[{},[2,1]],"ღ":[{},[0,0,2]],"ყ":[{},[2,1]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1]],"წ":[{},[2,1]],"ხ":[{},[2,1]],"ჯ":[{},[2,1]],"ჰ":[{},[2,1,2]]}],"ე":[{"ა":[{"რ":[{"ა":[{},[0,0,0,0,3]]}]},[0,1]],"ბ":[{"ს":[{"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]]}]},[0,1]],"გ":[{"ვ":[{"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"რ":[{},[0,0,3]],"შ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ჭ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ლ":[{},[0,2]],"მ":[{"ვ":[{},[0,0,3]]},[0,2,1]],"რ":[{"ჩ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ი":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2]],"ც":[{"დ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"დ":[{"ზ":[{},[0,2,1]],"ნ":[{},[0,2,1]],"რ":[{"დ":[{},[0,0,3]],"კ":[{},[0,0,3]]}],"ს":[{"ა":[{},[0,0,3]]}]},[0,1]],"ე":[{"ტ":[{},[2]]},[0,1]],"ვ":[{"ბ":[{"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]]}],"კ":[{"რ":[{},[0,0,3]]}],"ლ":[{"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ჩ":[{},[0,0,3]]}],"მ":[{"ც":[{},[0,0,3]]}],"რ":[{"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ჩ":[{},[0,0,3]],"ც":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"რ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ზ":[{"რ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]]}]},[0,1]],"თ":[{"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2,1]],"ლ":[{},[0,2,1]],"რ":[{"გ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ს":[{},[0,0,3]],"წ":[{},[0,0,3]]}],"ქ":[{"ლ":[{},[0,0,3]]}]},[0,1]],"ი":[{},[0,1]],"კ":[{"დ":[{},[0,0,1]],"ვ":[{"რ":[{},[0,0,3]]}],"რ":[{"თ":[{},[0,0,3]]}]},[0,1]],"ლ":[{"გ":[{"ვ":[{},[0,0,3]]}],"დ":[{"შ":[{},[0,0,3]]}],"ვ":[{"ყ":[{},[0,0,3]]}],"მ":[{"ყ":[{},[0,0,3]],"ძ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"მ":[{"ა":[{"ს":[{"მ":[{"ე":[{"თ":[{},[0,0,0,4]]}]}]}]}],"ბ":[{"რ":[{},[0,0,3]]}],"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"პ":[{"მ":[{},[0,0,3]]}],"რ":[{"ჩ":[{},[0,0,3]],"ც":[{},[0,0,3]]}],"ს":[{"გ":[{},[0,0,3]],"კ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ყ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ჭ":[{"მ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}]},[0,1]],"ნ":[{"დ":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ტ":[{"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჩ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ო":[{},[0,1]],"პ":[{},[0,1]],"რ":[{"ა":[{"რ":[{},[0,2,1]]}],"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]]}],"თ":[{"ბ":[{},[0,0,3]],"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ფ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ხ":[{"ა":[{},[0,0,2]]}]}],"კ":[{"ვ":[{},[0,0,3]]}],"მ":[{"კ":[{},[0,0,3]]}],"ო":[{"ფ":[{},[0,0,1]]}],"პ":[{"ლ":[{},[0,0,3]]}],"ს":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ტ":[{"ბ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ფ":[{"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ლ":[{},[0,0,3]]}],"ჩ":[{"ხ":[{},[0,0,3]]}],"ც":[{"ვ":[{},[0,0,3]]}],"ძ":[{"ნ":[{},[0,0,3]]},[0,2,1]],"წ":[{"ვ":[{},[0,0,3]],"კ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ს":[{},[0,0,3]]}]},[0,1]],"ს":[{"დ":[{"გ":[{},[0,0,3]]}],"ვ":[{"გ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"მ":[{},[0,0,3]]}],"ნ":[{},[0,2]],"ტ":[{"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]]}]},[0,1]],"ტ":[{"გ":[{"ვ":[{},[0,0,3]]}],"კ":[{},[0,2,1]],"ლ":[{"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"რ":[{"ფ":[{},[0,0,3]]},[0,0,1]],"შ":[{"ი":[{},[0,0,3]]},[0,2]],"ჩ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ნ":[{},[0,0,3]]}]},[0,1]],"უ":[{},[0,1]],"ფ":[{},[0,1]],"ქ":[{"ვ":[{"თ":[{},[0,0,3]],"ს":[{},[0,0,3]]},[0,0,1]],"მ":[{"ნ":[{},[0,0,3]]}],"რ":[{"თ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ც":[{},[0,0,3]]}],"ტ":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ც":[{"ნ":[{},[0,0,3]]}]}],"ღ":[{"ვ":[{},[0,0,1]]},[0,1]],"ყ":[{"ნ":[{"დ":[{},[0,0,3]]},[0,0,1]],"რ":[{"დ":[{},[0,0,3]]},[0,0,1]]},[0,1]],"შ":[{"ვ":[{"ნ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}],"ფ":[{"ო":[{},[0,0,3]]},[0,2]]},[0,1]],"ჩ":[{},[0,1]],"ც":[{"ვ":[{"ლ":[{},[0,0,3]]}],"ქ":[{"ე":[{},[0,0,3]],"ი":[{},[0,0,3]]},[0,2]]},[0,1]],"ძ":[{"ვ":[{"რ":[{},[0,0,3]]}]},[0,1]],"წ":[{"ვ":[{"ზ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"მ":[{},[0,2]],"რ":[{},[0,2,1]]},[0,1]],"ჭ":[{"ვ":[{"დ":[{},[0,0,3]],"მ":[{},[0,0,3]]}]}],"ხ":[{"დ":[{"გ":[{},[0,0,3]]}],"ვ":[{"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]]},[0,0,1]],"ზ":[{},[0,0,1]],"მ":[{"ძ":[{},[0,0,3]]},[0,2,1]],"ტ":[{"ნ":[{},[0,0,3]]}],"ყ":[{},[0,0,1]],"ჰ":[{},[0,0,1]]},[0,1]],"ჯ":[{"გ":[{"ვ":[{},[0,0,3]]},[0,0,1]],"ვ":[{},[0,2,1]],"ნ":[{},[0,2]]},[0,1]],"ჰ":[{"კ":[{"რ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}]}]}],"ვ":[{"ბ":[{},[2,1,2]],"გ":[{},[2,1,2]],"დ":[{},[2,1,2]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{},[2,1,2]],"ი":[{"რ":[{"უ":[{},[0,0,2]]}]}],"კ":[{"ა":[{"რ":[{"გ":[{"ს":[{".":[{},[0,0,0,0,4]]}]}]}]}]},[2,1,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1,2]],"ო":[{"ხ":[{},[2,1]]}],"პ":[{},[2,1]],"ჟ":[{},[0,0,2]],"რ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"ს":[{"თ":[{"ხ":[{},[0,0,3]]}]},[2,1,2]],"ტ":[{},[2,1,2]],"უ":[{},[1]],"ფ":[{},[2,1,2]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1]],"ყ":[{},[2,1,2]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1]],"ც":[{},[2,1,2]],"ძ":[{},[2,1,2]],"წ":[{},[2,1,2]],"ჭ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1,2]]}],"ზ":[{"ბ":[{},[2,1]],"გ":[{},[2,1]],"დ":[{},[2,1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"რ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"ს":[{},[2,1,2]],"ღ":[{},[0,0,2]],"შ":[{},[2,1]]}],"თ":[{"ა":[{"ს":[{"ა":[{"თ":[{},[0,0,2]]}],"ე":[{},[0,0,2]]}]}],"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{},[2,1,2]],"ვ":[{"ა":[{},[0,1]],"ო":[{},[0,1]],"რ":[{},[0,1]]},[0,0,2]],"ზ":[{},[2,1]],"თ":[{"ხ":[{},[0,2]]},[2,1]],"ი":[{"ქ":[{},[2,1]]}],"კ":[{},[2,1,2]],"ლ":[{"დ":[{},[0,1]]},[0,0,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"ო":[{"ც":[{"დ":[{"ა":[{"ა":[{},[2,1]]}]}]}]}],"რ":[{},[2,1,2]],"ს":[{},[2,1,2]],"ფ":[{},[2,1,2]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1]],"შ":[{},[2,1]],"ც":[{},[2,1,2]],"ხ":[{".":[{},[2]],"ს":[{"ა":[{},[3]]},[2]]},[0,0,2]],"ჯ":[{},[2,1]]}],"ი":[{"ა":[{"მ":[{"ზ":[{},[0,0,3,2]]}]},[0,1]],"ბ":[{"ვ":[{"ლ":[{},[0,0,3]]}],"რ":[{"ზ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ჭ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}]},[0,1]],"გ":[{"ვ":[{"რ":[{},[0,0,3]],"ყ":[{},[0,0,3]]}],"ლ":[{},[0,2,1]],"მ":[{},[0,2]],"რ":[{"გ":[{},[0,0,3]]}],"შ":[{"ი":[{},[0,0,3]]},[0,2]]},[0,1]],"დ":[{"გ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ზ":[{},[0,2,1]],"მ":[{"ნ":[{},[0,0,3]],"პ":[{},[0,0,3]]}],"ნ":[{},[0,2,1]],"რ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ს":[{"ა":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ე":[{},[0,1]],"ვ":[{"ბ":[{"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"თ":[{"თ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]]}],"ჟ":[{},[0,2]],"რ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ც":[{},[0,0,3]]}],"ს":[{"ღ":[{},[0,0,3]]}],"ფ":[{"ს":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ზ":[{"ვ":[{"ნ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]]}],"მ":[{"ზ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]]}]},[0,1]],"თ":[{"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2,1]],"ლ":[{"დ":[{},[0,0,3]]},[0,2,1]],"მ":[{"კ":[{},[0,0,3]],"მ":[{},[0,0,3]],"პ":[{},[0,0,3]]}],"რ":[{"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ფ":[{"ლ":[{},[0,0,3]]}],"ც":[{"ნ":[{},[0,0,3]]}]},[0,1]],"ი":[{},[0,1]],"კ":[{"ბ":[{"ი":[{},[0,0,3]]}],"დ":[{},[0,0,1]],"ვ":[{"დ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}]},[0,1]],"ლ":[{"მ":[{"ს":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"მ":[{"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"ნ":[{"დ":[{},[0,0,3]]}],"რ":[{"ბ":[{},[0,0,3]],"თ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]],"ხ":[{},[0,0,3]],"ჯ":[{},[0,0,3]]}],"ტ":[{"ვ":[{},[0,0,3]]}],"ყ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}]},[0,1]],"ნ":[{"გ":[{"რ":[{},[0,0,3]]}],"დ":[{"ბ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"რ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"თ":[{"ზ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ც":[{},[0,0,3]],"წ":[{},[0,0,3]]}],"ტ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ქ":[{"ლ":[{},[0,0,3]]}],"ღ":[{"ლ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"ძ":[{"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ო":[{},[0,1]],"პ":[{},[0,1]],"ჟ":[{"ღ":[{},[0,2]]},[0,1]],"რ":[{"გ":[{"ვ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"მ":[{"შ":[{},[0,0,3]]}],"ს":[{"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"უ":[{"ნ":[{},[0,0,1]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"შ":[{},[0,0,3]]}]},[0,1]],"ს":[{"დ":[{"გ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"მ":[{"გ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ტ":[{},[0,0,3]],"ქ":[{},[0,0,3]],"ყ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ც":[{},[0,0,3]],"ძ":[{},[0,0,3]]}],"ნ":[{},[0,0,1]],"ტ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ფ":[{"რ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ც":[{"ვ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}]}],"ტ":[{"ვ":[{"ლ":[{},[0,0,3]]},[0,0,1]],"კ":[{},[0,2,1]],"მ":[{"შ":[{},[0,0,3]]}],"რ":[{},[0,0,1]]},[0,1]],"უ":[{},[0,1]],"ფ":[{"რ":[{"დ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ქ":[{"ვ":[{"ნ":[{},[0,0,3]]},[0,0,1]],"მ":[{"ნ":[{},[0,0,3]]}],"ნ":[{"გ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ც":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}]}],"ღ":[{"ბ":[{"ა":[{"ლ":[{"მ":[{},[1]]}]}],"ლ":[{"ი":[{"ს":[{},[1]]}]},[0,0,3]]}],"ვ":[{"რ":[{},[0,0,3]],"წ":[{},[0,0,3]]},[0,0,1]],"რ":[{"მ":[{},[0,0,3]],"ჭ":[{},[0,0,3]]}]},[0,1]],"ყ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}]},[0,1]],"შ":[{"ვ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"კ":[{"რ":[{},[0,0,3]]}],"ფ":[{"ო":[{},[0,0,3]]}],"ხ":[{"ლ":[{},[0,0,3]]}]}],"ჩ":[{"ლ":[{},[0,2]],"ნ":[{"დ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ც":[{"ვ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ქ":[{"ე":[{},[0,0,3]],"ნ":[{},[0,0,3]]},[0,2]]},[0,1]],"ძ":[{"გ":[{"ნ":[{},[0,0,3]]}],"ვ":[{"რ":[{},[0,0,3]]}],"ლ":[{"შ":[{},[0,0,3]]}],"რ":[{"ნ":[{},[0,0,3]]}]},[0,1]],"წ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"კ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"მ":[{},[0,2]],"რ":[{"თ":[{},[0,0,3]]},[0,2,1]]},[0,1]],"ჭ":[{"ვ":[{"რ":[{},[0,0,3]]}],"ზ":[{},[0,2,1]]},[0,1]],"ხ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]},[0,0,1]],"მ":[{},[0,2,1]],"რ":[{"ჩ":[{},[0,0,3]],"წ":[{},[0,0,3]]},[0,0,1]]},[0,1]],"ჯ":[{"ზ":[{},[0,2,1]],"ნ":[{},[0,2,1]]},[0,1]],"ჰ":[{"გ":[{"ვ":[{},[0,0,3]]}],"კ":[{"რ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}]}]}],"კ":[{"ბ":[{},[1,2]],"დ":[{"ი":[{},[0,1]],"ო":[{},[0,1]]},[2]],"ე":[{},[1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"ო":[{"მ":[{"ს":[{},[0,0,3,2]]}]}],"პ":[{},[2]],"რ":[{},[2,1,2]],"ს":[{},[2,1]],"ქ":[{},[2,1]],"შ":[{},[2,1]],"ჰ":[{},[2,1]]}],"ლ":[{"ა":[{"მ":[{"ჭ":[{},[0,0,3,2]]}]},[1]],"ბ":[{"რ":[{"ტ":[{},[0,0,0,3]],"ჭ":[{},[0,0,0,3]]}]},[2,1]],"გ":[{},[2,1,2]],"დ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"ე":[{"ხ":[{},[2]],"ჯ":[{"ვ":[{},[2]]}]}],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1,2]],"ი":[{"თ":[{"ქ":[{},[0,0,3,2]]}]}],"კ":[{},[2,1]],"ლ":[{},[2,1]],"მ":[{},[2,1,2]],"ნ":[{},[2,1,2]],"ო":[{},[0,0,1]],"პ":[{},[2,1]],"ჟ":[{},[2,1]],"რ":[{},[2,1]],"ს":[{},[2,1,2]],"ტ":[{},[2,1,2]],"უ":[{},[1]],"ფ":[{},[2,1]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1,2]],"ყ":[{},[2,1,2]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1,2]],"ც":[{},[2,1,2]],"ძ":[{},[2,1]],"წ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1]],"ჰ":[{},[2,1,2]]}],"მ":[{"ა":[{"ს":[{"მ":[{},[0,0,3,2]]}],"ყ":[{"ლ":[{},[0,0,3,2]]}],"ხ":[{"ვ":[{},[0,0,0,3]]}]},[1]],"ბ":[{},[2,1,2]],"გ":[{},[2,1,2]],"დ":[{"ღ":[{},[0,2]]},[2,1,2]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{},[2,1,2]],"ი":[{"ს":[{"ტ":[{"რ":[{"ს":[{".":[{},[0,0,0,4]]}]}]}]}]},[1]],"კ":[{},[2,1,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{},[2,1,2]],"ო":[{"თ":[{"ხ":[{"ს":[{},[2,1]]}]}]}],"პ":[{},[2,1,2]],"ჟ":[{},[2,1]],"რ":[{},[2,1,2]],"ს":[{},[2,1,2]],"ტ":[{},[2,1,2]],"უ":[{"ს":[{"ო":[{},[0,0,3]]}]}],"ფ":[{},[2,1,2]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1,2]],"ყ":[{},[2,1,2]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1,2]],"ც":[{},[2,1,2]],"ძ":[{},[2,1,2]],"წ":[{},[2,1,2]],"ჭ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1,2]]}],"ნ":[{"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{"ე":[{"რ":[{},[0,0,0,2]]}]},[2,1,2]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{},[2,1,2]],"ი":[{"ა":[{"შ":[{"ტ":[{},[0,0,0,3]]}]}],"თ":[{"ქ":[{},[0,0,3,2]]}],"ს":[{"ტ":[{"რ":[{"ს":[{".":[{},[0,0,0,4]]}]}]}]}]},[1]],"კ":[{},[2,1,2]],"ლ":[{},[2,1]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"პ":[{},[2,1]],"ჟ":[{},[2,1]],"რ":[{},[2,1]],"ს":[{},[2,1,2]],"ტ":[{"ს":[{"ა":[{},[0,3]],"ტ":[{},[0,3]]}]},[2,1,2]],"უ":[{},[1]],"ფ":[{},[2,1,2]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1,2]],"ყ":[{},[2,1,2]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1,2]],"ც":[{},[2,1,2]],"ძ":[{},[2,1,2]],"წ":[{},[2,1,2]],"ჭ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1,2]]}],"ო":[{"ა":[{},[0,1]],"ბ":[{"თ":[{"მ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ჭ":[{},[0,0,3]]}]},[0,1]],"გ":[{"ვ":[{"ბ":[{},[0,0,3]],"გ":[{},[0,0,3]],"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"თ":[{"ხ":[{},[0,0,0,3]]}],"კ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]],"ყ":[{},[0,0,3]],"შ":[{},[0,0,3]],"ც":[{},[0,0,3]],"ძ":[{},[0,0,3]],"წ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"კ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{},[0,2,1]],"მ":[{},[0,2]],"ს":[{"ვ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ი":[{},[0,0,3]]},[0,2]],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"დ":[{"გ":[{"ნ":[{},[0,0,3]]}],"ზ":[{},[0,2,1]],"ნ":[{},[0,2,1]]},[0,1]],"ე":[{},[0,1]],"ვ":[{"ბ":[{"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"ზ":[{"ს":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]]}],"ლ":[{"ბ":[{},[0,0,3]],"ზ":[{},[0,0,3]]}],"მ":[{"ც":[{},[0,0,3]]}],"ნ":[{"დ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]],"თ":[{},[0,0,3]],"ჩ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]],"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ზ":[{"ვ":[{"რ":[{},[0,0,3]]}],"რ":[{"დ":[{},[0,0,3]]}]},[0,1]],"თ":[{"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]},[0,2]],"ლ":[{"შ":[{},[0,0,3]]},[0,2,1]]},[0,1]],"ი":[{},[0,1]],"კ":[{"დ":[{},[0,0,1]],"ვ":[{"დ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ლ":[{"დ":[{"შ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"მ":[{"ბ":[{"რ":[{},[0,0,3]]}],"გ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"პ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"რ":[{"თ":[{},[0,0,3]],"ჩ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]],"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ნ":[{"გ":[{"რ":[{},[0,0,3]]}],"დ":[{"რ":[{},[0,0,3]]}],"კ":[{"რ":[{},[0,0,3]]}],"მ":[{"დ":[{},[0,0,3]]}],"ს":[{"კ":[{},[0,0,3]],"პ":[{},[0,0,3]],"ტ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}],"ფ":[{"ლ":[{},[0,0,3]]}],"ხ":[{"ლ":[{},[0,0,3]]}]},[0,1]],"ო":[{},[0,1]],"პ":[{},[0,1]],"რ":[{"ბ":[{"ლ":[{},[0,0,3]]}],"თ":[{"მ":[{},[0,0,3]],"ქ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"მ":[{"ხ":[{},[0,0,3]]}],"ს":[{"მ":[{},[0,0,3]]}],"ტ":[{"მ":[{},[0,0,3]],"რ":[{},[0,0,3]],"ს":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ძ":[{},[0,2,1]]},[0,1]],"ს":[{"დ":[{"გ":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"დ":[{},[0,0,3]]}],"ნ":[{},[0,2,1]],"ტ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ფ":[{"რ":[{},[0,0,3]]}],"ც":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ძ":[{"ვ":[{},[0,0,3]]}],"წ":[{"ვ":[{},[0,0,3]]}],"ჭ":[{"რ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ტ":[{"კ":[{},[0,2,1]],"რ":[{"დ":[{},[0,0,3]]},[0,0,1]],"შ":[{"ი":[{},[0,0,3]]},[0,2]]},[0,1]],"უ":[{},[0,1]],"ფ":[{"ლ":[{"მ":[{},[0,0,3]]}]},[0,1]],"ქ":[{"ვ":[{},[0,2,1]],"მ":[{"ზ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"რ":[{"თ":[{},[0,0,3]]}],"ს":[{"თ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}]}],"ღ":[{"ვ":[{"რ":[{},[0,0,3]]},[0,0,1]],"ლ":[{},[1]]},[0,1]],"ყ":[{"ა":[{},[0,1]],"ე":[{},[0,1]],"ვ":[{"ნ":[{},[0,0,3]]}],"ო":[{},[0,1]],"რ":[{},[0,0,1]],"უ":[{},[0,1]]}],"შ":[{"კ":[{"ზ":[{},[0,0,3]]}]},[0,1]],"ჩ":[{"ნ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ც":[{"ვ":[{"ლ":[{},[0,0,3]]}],"ქ":[{"რ":[{},[0,0,3]]},[0,2]]},[0,1]],"ძ":[{"ვ":[{"რ":[{},[0,0,3]]}]},[0,1]],"წ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"მ":[{"დ":[{},[0,0,3]]},[0,2]],"რ":[{},[0,2]]},[0,1]],"ჭ":[{"ლ":[{},[0,0,1]]}],"ხ":[{"ვ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]]},[0,0,1]],"მ":[{},[0,2]],"რ":[{"ჩ":[{},[0,0,3]]},[0,0,1]],"ტ":[{"ნ":[{},[0,0,3]]}]},[0,1]],"ჯ":[{},[0,1]],"ჰ":[{"გ":[{"ვ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ყ":[{"ვ":[{},[0,0,3]]}],"ხ":[{"ვ":[{},[0,0,3]]}]}]}],"პ":[{"დ":[{},[2,1]],"ვ":[{},[2,1]],"ზ":[{},[2,1]],"კ":[{},[0,1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{},[2,1]],"რ":[{},[2,1,2]],"ს":[{},[2]],"ტ":[{},[2,1]],"ყ":[{},[0,0,2]],"შ":[{},[2,1]],"ჩ":[{},[2,1]],"წ":[{},[2,1,2]]}],"ჟ":[{"ბ":[{},[2,1]],"დ":[{},[2,1]],"ვ":[{},[2,1]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"ი":[{},[1]],"კ":[{},[2,1]],"ლ":[{"ე":[{"ტ":[{"ა":[{},[3,2]]}]}]},[2,1]],"მ":[{},[2,1]],"ო":[{},[1]],"რ":[{},[2,1,2]],"ს":[{},[2]],"ღ":[{"ე":[{},[0,1]]}],"შ":[{},[2,1]]}],"რ":[{"ა":[{"მ":[{"ბ":[{"ა":[{"ვ":[{"ი":[{".":[{},[3]]}]}]}]},[2,1]]}],"ჩ":[{"ა":[{},[2,1]]}]}],"ბ":[{},[2,1,2]],"გ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"დ":[{"ს":[{"ა":[{},[0,3]]}]},[2,1,2]],"ე":[{"კ":[{"ო":[{},[2,1]]}],"ფ":[{"ე":[{},[0,1]]}]}],"ვ":[{},[2,1,2]],"ზ":[{},[2,1,2]],"თ":[{"ე":[{"რ":[{"თ":[{"ს":[{".":[{},[0,0,0,0,4]]}]}]}]}],"ს":[{"ა":[{},[0,3]]}],"ხ":[{"მ":[{},[0,3]]}]},[2,1,2]],"ი":[{"ბ":[{"ღ":[{},[0,0,2]]}],"მ":[{"ღ":[{},[0,0,3]]}]},[1]],"კ":[{},[2,1,2]],"ლ":[{},[2,1]],"მ":[{"თ":[{},[0,0,2]],"ყ":[{},[0,0,2]]},[2,1]],"ნ":[{},[2,1]],"ო":[{"ფ":[{},[2]]},[0,0,1]],"პ":[{},[2,1,2]],"ჟ":[{},[2,1]],"ს":[{},[2,1,2]],"ტ":[{},[2,1,2]],"უ":[{"ს":[{"ო":[{},[0,0,3]]}]},[1]],"ფ":[{},[2,1,2]],"ქ":[{},[2,1,2]],"ღ":[{},[2,1,2]],"ყ":[{},[2,1,2]],"შ":[{},[2,1,2]],"ჩ":[{"ხ":[{"ე":[{},[0,3]]},[0,2]]},[2,1,2]],"ც":[{},[2,1,2]],"ძ":[{"ლ":[{},[0,1]]},[0,0,2]],"წ":[{},[2,1,2]],"ჭ":[{},[2,1]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1,2]],"ჰ":[{},[2,1,2]]}],"ს":[{"ა":[{},[1]],"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{},[2,1,2]],"ე":[{},[1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1,2]],"ი":[{"რ":[{"ვ":[{},[0,0,3,2]]}]},[1]],"კ":[{},[2,1,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{"ო":[{},[0,1]]}],"ო":[{"რ":[{"ა":[{},[2,1]]}],"ღ":[{},[0,1]]},[1]],"პ":[{},[2,1,2]],"რ":[{},[2,1,2]],"ს":[{},[2,1]],"ტ":[{},[2,1,2]],"უ":[{},[1]],"ფ":[{},[2,1,2]],"ქ":[{},[0,1]],"ღ":[{},[2,1]],"ყ":[{},[2,1]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1]],"ც":[{},[2,1,2]],"ძ":[{},[2,1,2]],"წ":[{},[2,1,2]],"ჭ":[{},[2,1,2]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1]]}],"ტ":[{"ა":[{"ჯ":[{"გ":[{},[0,0,3]]}]}],"ბ":[{},[2,1]],"გ":[{},[2,1,2]],"დ":[{},[2,1]],"ე":[{"ქ":[{"ს":[{"ტ":[{"ს":[{".":[{},[0,0,0,4]]}]}]}]}]}],"ვ":[{"ა":[{},[0,1]]},[2,0,2]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"კ":[{"უ":[{},[0,1]]},[0,0,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"პ":[{},[2,1]],"რ":[{"ო":[{},[0,1]],"ფ":[{},[0,1]]},[2,0,2]],"ს":[{},[2,1,2]],"ტ":[{},[2,1]],"ფ":[{},[0,2]],"ყ":[{},[0,0,2]],"შ":[{},[0,2]],"ჩ":[{},[2,1,2]],"ც":[{},[2,1]],"წ":[{},[2,1]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1]]}],"უ":[{"ა":[{"ა":[{},[0,2]]},[0,1]],"ბ":[{"ლ":[{"ზ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"რ":[{"კ":[{},[0,0,3]],"ყ":[{},[0,0,3]]}]}],"გ":[{"მ":[{},[0,2]],"რ":[{"ნ":[{},[0,0,3]]}]},[0,1]],"დ":[{"გ":[{"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ზ":[{},[0,2,1]],"რ":[{"ტ":[{},[0,0,3]]}],"ს":[{"ა":[{},[0,0,3]]}]},[0,1]],"ე":[{},[0,1]],"ვ":[{},[0,1]],"ზ":[{"რ":[{"დ":[{},[0,0,3]]}]},[0,1]],"თ":[{"ე":[{"ქ":[{},[0,2,1]]}],"ვ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]},[0,2,1]],"ს":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ი":[{"ა":[{},[0,0,2]]},[0,1]],"კ":[{"ვ":[{"დ":[{},[0,0,3]]}],"ლ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ლ":[{"ა":[{"ფ":[{},[0,2,1]]}],"გ":[{"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]]}],"ე":[{"კ":[{},[0,2,1]]}],"თ":[{"ბ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"მ":[{"კ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ნ":[{"დ":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"ჩ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"მ":[{"დ":[{"გ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"ს":[{"გ":[{},[0,0,3]],"ხ":[{},[0,0,3]]}],"ტ":[{"ყ":[{},[0,0,2]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"შ":[{"ვ":[{},[0,0,3]]}],"ჩ":[{"ნ":[{},[0,0,3]]}],"ც":[{"რ":[{},[0,0,3]]}]},[0,1]],"ნ":[{"გ":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"დ":[{"გ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"თ":[{"ქ":[{},[0,0,3]]}],"კ":[{"ლ":[{},[0,0,3]]}],"ტ":[{"რ":[{},[0,0,3]]}],"ღ":[{"რ":[{},[0,0,3]]}],"ძ":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ხ":[{"რ":[{},[0,0,3]]}]},[0,1]],"ო":[{},[0,1]],"პ":[{"რ":[{"შ":[{},[0,0,3]]}]},[0,1]],"ჟ":[{},[0,1]],"რ":[{"ბ":[{"ლ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"გ":[{"ზ":[{},[0,0,3]]}],"დ":[{"თ":[{},[0,0,3]],"ს":[{},[0,0,3]]}],"ვ":[{"ლ":[{},[0,0,3]]}],"თ":[{"ბ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]],"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ს":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"ტ":[{"ლ":[{},[0,0,3]]}],"ფ":[{"ს":[{},[0,0,3]]}],"ღ":[{"ვ":[{},[0,0,3]]}],"ჩ":[{"ქ":[{},[0,0,3]]}],"ც":[{"ლ":[{},[0,0,3]]}],"ჯ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ს":[{"ვ":[{"ლ":[{},[0,0,3]],"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"კ":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ო":[{},[0,2]],"რ":[{"ვ":[{},[0,0,3]],"ნ":[{},[0,0,3]]}],"ტ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]],"მ":[{},[0,0,3]]}],"ხ":[{"დ":[{},[0,0,3]],"ვ":[{},[0,0,3]]}]}],"ტ":[{"კ":[{},[0,2,1]],"რ":[{},[0,0,1]]},[0,1]],"უ":[{},[0,1]],"ფ":[{"ლ":[{"დ":[{},[0,0,3]]}],"ჯ":[{"გ":[{},[0,0,3]]}]}],"ქ":[{"ვ":[{},[0,0,1]],"თ":[{},[0,0,1]],"მ":[{"დ":[{},[0,0,3]],"ნ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"ს":[{"ვ":[{},[0,0,3]]}]}],"ღ":[{"რ":[{"მ":[{},[0,0,3]]}]},[0,1]],"ყ":[{"დ":[{},[0,0,1]]},[0,1]],"შ":[{"ვ":[{"რ":[{},[0,0,3]]}],"ტ":[{"მ":[{},[0,0,3]],"რ":[{},[0,0,3]]}]},[0,1]],"ჩ":[{"ნ":[{"დ":[{},[0,0,3]]}]},[0,1]],"ც":[{"ვ":[{"ლ":[{},[0,0,3]]}],"ქ":[{"დ":[{},[0,0,3]],"ი":[{},[0,0,3]],"უ":[{},[0,0,3]]},[0,2]]},[0,1]],"ძ":[{"ა":[{},[0,1]],"ე":[{},[0,1]],"ვ":[{"ლ":[{},[0,0,3]],"რ":[{},[0,0,3]]}]}],"წ":[{"ვ":[{"დ":[{},[0,0,3]],"რ":[{},[0,0,3]]}],"შ":[{},[0,2]]},[0,1]],"ჭ":[{"ვ":[{"რ":[{},[0,0,3]]}],"კ":[{"ვ":[{},[0,0,3]]}],"შ":[{},[0,2]]},[0,1]],"ხ":[{"ვ":[{"დ":[{},[0,0,3]]},[0,0,1]],"ლ":[{"ზ":[{},[0,0,3]],"მ":[{},[0,0,3]],"შ":[{},[0,0,3]]}],"მ":[{},[0,2,1]],"რ":[{"ჩ":[{},[0,0,3]]},[0,0,1]],"ტ":[{"ვ":[{},[0,0,3]]}]},[0,1]],"ჯ":[{"ლ":[{},[0,2]],"რ":[{"ა":[{},[0,0,3]],"ი":[{},[0,0,3]]}]},[0,1]],"ჰ":[{},[0,1]]}],"ფ":[{"ა":[{},[1]],"ბ":[{},[2,1]],"დ":[{},[2,1]],"ე":[{},[1]],"ვ":[{},[2,1]],"ზ":[{},[2,1]],"თ":[{},[2,1,2]],"ი":[{"ა":[{"რ":[{},[2,1]]}]},[1]],"კ":[{},[2,1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{},[2,1]],"ო":[{},[1]],"რ":[{"დ":[{},[0,0,2]],"ქ":[{},[0,0,2]]},[2,1]],"ს":[{},[2,1,2]],"ტ":[{},[2,1]],"უ":[{},[1]],"ქ":[{},[2,1]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1]],"ც":[{},[2,1]],"ხ":[{},[0,0,2]],"ჯ":[{},[0,1,2]]}],"ქ":[{"ა":[{},[1]],"გ":[{},[0,1]],"დ":[{},[0,1]],"ე":[{},[1]],"ვ":[{"დ":[{},[0,1]],"თ":[{"ო":[{},[0,3]]}],"ს":[{"მ":[{},[0,3]],"ო":[{},[0,3]]}]},[0,0,2]],"ზ":[{},[0,1]],"ი":[{},[1]],"ლ":[{"ე":[{},[0,1]],"ო":[{},[0,1]]},[2,0,2]],"მ":[{},[0,1,2]],"ნ":[{},[0,1,2]],"ო":[{},[1]],"ჟ":[{},[0,1]],"რ":[{},[0,1,2]],"ს":[{},[0,1,2]],"ტ":[{},[0,1,2]],"უ":[{},[1]],"ქ":[{},[0,1]],"ღ":[{},[0,1]],"შ":[{},[0,1]],"ც":[{},[0,1,2]]}],"ღ":[{"ა":[{"ტ":[{},[1]]}],"ბ":[{},[2,1,2]],"გ":[{},[0,1]],"დ":[{},[2,1,2]],"ვ":[{"ი":[{},[0,1]],"შ":[{},[0,1]]},[2,0,2]],"ზ":[{},[2,1]],"თ":[{},[2,1,2]],"კ":[{},[0,1,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"რ":[{},[2,1,2]],"ს":[{},[2,1,2]],"ტ":[{"ყ":[{},[0,2]]},[0,1]],"ფ":[{"რ":[{},[0,0,0,2]]},[0,1]],"ქ":[{},[0,1,2]],"შ":[{},[2,1]],"ძ":[{},[0,1,2]],"წ":[{},[2,1]],"ჭ":[{},[0,1]]}],"ყ":[{"ბ":[{},[2,1]],"დ":[{},[2,0,2]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"ლ":[{},[2,0,2]],"მ":[{},[2,1,2]],"ნ":[{"ე":[{},[0,1]],"ო":[{},[0,1]]},[2,0,2]],"რ":[{"ე":[{},[0,1]]},[2,0,2]],"ს":[{},[2]],"შ":[{},[2,1]]}],"შ":[{"ა":[{"ხ":[{"ვ":[{},[0,0,3]]}]},[1]],"გ":[{},[0,1]],"დ":[{},[2,1]],"ე":[{},[1]],"ვ":[{},[2,1,2]],"ზ":[{},[0,1]],"თ":[{},[2,1]],"ი":[{"ა":[{"თ":[{},[0,0,0,3,2]]}]},[1]],"კ":[{},[2,1,2]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{},[2,1]],"ო":[{},[1]],"პ":[{},[2,1]],"რ":[{},[2,1]],"ს":[{},[2,1]],"ტ":[{"ე":[{"რ":[{"ი":[{},[0,2]],"ო":[{},[0,2]]}]}]},[2,1,2]],"უ":[{},[1]],"ფ":[{},[0,2]],"ქ":[{},[2,1,2]],"შ":[{},[2,1]],"ჩ":[{},[2,1]],"ხ":[{},[2,1,2]],"ჯ":[{},[2,1]]}],"ჩ":[{"ბ":[{},[2,1]],"დ":[{},[2,1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1]],"მ":[{},[2,1]],"ნ":[{},[2,1,2]],"ო":[{},[0,0,1]],"რ":[{},[2,1,2]],"ს":[{},[2]],"ქ":[{},[2,1,2]],"შ":[{},[2,1]],"ხ":[{},[0,0,2]]}],"ც":[{"ბ":[{},[2,1]],"დ":[{},[2,1]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2,1,2]],"კ":[{},[2,1]],"ლ":[{},[2,1]],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"რ":[{},[2,1]],"ს":[{},[2,1]],"ქ":[{"დ":[{},[0,1]],"ნ":[{},[0,1]],"რ":[{},[0,1]]},[0,2,2]],"ღ":[{},[2,1]],"შ":[{},[2,1]],"ხ":[{},[0,0,2]]}],"ძ":[{"ა":[{"რ":[{"ც":[{"ვ":[{"ს":[{".":[{},[0,0,0,4]]}]}]}]}]}],"გ":[{},[2,1,2]],"ვ":[{},[2,1,2]],"ზ":[{},[2,1]],"თ":[{},[2]],"ი":[{},[1]],"ლ":[{},[2,1,2]],"მ":[{},[2,1]],"ნ":[{"ე":[{},[0,1]]},[2]],"რ":[{},[2,1,2]],"ს":[{},[2]],"უ":[{},[1]],"ღ":[{},[1,0,2]],"ჭ":[{},[0,2]]}],"წ":[{"ა":[{"გ":[{"ლ":[{},[0,0,3]]}]}],"ბ":[{},[2,1]],"გ":[{},[2,1]],"ვ":[{},[2,1,2]],"კ":[{},[2,1,2]],"ლ":[{"ი":[{},[0,1]]}],"მ":[{"დ":[{},[0,1]],"ე":[{},[0,1]],"ო":[{},[0,1]],"ყ":[{},[0,1]]},[0,0,2]],"ნ":[{},[2,1]],"რ":[{"თ":[{},[0,1]]},[0,0,2]],"ყ":[{},[0,0,2]]}],"ჭ":[{"ა":[{},[1]],"დ":[{},[2,1]],"ე":[{},[1]],"ვ":[{},[2,1,2]],"ი":[{},[1]],"კ":[{},[0,1,2]],"ლ":[{"ო":[{},[0,1]]}],"მ":[{},[2,1,2]],"ნ":[{},[2,1]],"ო":[{},[1]],"რ":[{},[2,1]],"უ":[{},[1]],"ყ":[{},[0,0,2]]}],"ხ":[{"ა":[{"ლ":[{"ა":[{"ხ":[{},[0,0,2,1]]}]}]}],"ბ":[{},[2,1]],"გ":[{},[0,0,2]],"დ":[{},[2,1,2]],"ვ":[{"ე":[{},[0,1]],"ი":[{},[0,1]],"რ":[{},[0,1]]},[2,0,2]],"ზ":[{},[2,0,2]],"თ":[{},[2,1]],"ლ":[{},[2,1,2]],"მ":[{},[0,0,2]],"ნ":[{},[2,1]],"პ":[{},[2,1]],"რ":[{},[2,0,2]],"ს":[{},[2,1,2]],"ტ":[{},[2,1,2]],"ქ":[{},[2,1]],"ყ":[{},[2]],"შ":[{},[2,1,2]],"ჩ":[{},[2,1]],"ც":[{},[2,1]],"წ":[{},[2,1]],"ხ":[{},[2,1]],"ჰ":[{},[2,0,2]]}],"ჯ":[{"გ":[{},[2,0,2]],"დ":[{},[2,1]],"ვ":[{},[0,0,2]],"თ":[{},[2,1]],"ო":[{"რ":[{"ი":[{},[0,0,3]]},[0,0,2,1]]}],"რ":[{"ა":[{},[0,1]]},[0,2]],"ს":[{},[2,1]],"შ":[{},[0,2]]}],"ჰ":[{"ა":[{},[1]],"გ":[{},[0,1,2]],"ე":[{},[1]],"ი":[{},[1]],"კ":[{},[0,1,2]],"მ":[{},[0,1]],"პ":[{},[0,1]],"რ":[{},[0,1]],"ს":[{},[0,1]],"ფ":[{},[0,1]],"ქ":[{},[0,1]],"ღ":[{},[0,1]],"ყ":[{},[0,1,2]],"ხ":[{},[0,1,2]]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
