"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    administeredVaccineLoader: function() {
        return administeredVaccineLoader;
    },
    labTestPanelLoader: function() {
        return labTestPanelLoader;
    },
    loaderFactory: function() {
        return loaderFactory;
    },
    patientDataLoader: function() {
        return patientDataLoader;
    },
    patientFieldDefinitionLoader: function() {
        return patientFieldDefinitionLoader;
    },
    permissionLoader: function() {
        return permissionLoader;
    },
    referenceDataLoaderFactory: function() {
        return referenceDataLoaderFactory;
    },
    translatedStringLoader: function() {
        return translatedStringLoader;
    }
});
const _datefns = require("date-fns");
const _exceldatetojs = require("excel-date-to-js");
const _constants = require("@tamanu/constants");
function stripNotes(fields) {
    const values = {
        ...fields
    };
    delete values.note;
    return values;
}
const loaderFactory = (model)=>(fields)=>[
            {
                model,
                values: stripNotes(fields)
            }
        ];
function referenceDataLoaderFactory(type) {
    return ({ id, code, name, visibilityStatus })=>[
            {
                model: 'ReferenceData',
                values: {
                    id,
                    type,
                    code: typeof code === 'number' ? `${code}` : code,
                    name,
                    visibilityStatus
                }
            }
        ];
}
function patientFieldDefinitionLoader(values) {
    return [
        {
            model: 'PatientFieldDefinition',
            values: {
                ...stripNotes(values),
                options: (values.options || '').split(',').map((v)=>v.trim()).filter((v)=>v !== '')
            }
        }
    ];
}
function administeredVaccineLoader(item) {
    const { encounterId, administeredVaccineId, date: excelDate, reason, consent, locationId, departmentId, examinerId, patientId, ...data } = item;
    const date = excelDate ? (0, _exceldatetojs.getJsDateFromExcel)(excelDate) : null;
    const startDate = date ? (0, _datefns.startOfDay)(date) : null;
    const endDate = date ? (0, _datefns.endOfDay)(date) : null;
    return [
        {
            model: 'Encounter',
            values: {
                id: encounterId,
                encounterType: _constants.ENCOUNTER_TYPES.CLINIC,
                startDate,
                endDate,
                reasonForEncounter: reason,
                locationId,
                departmentId,
                examinerId,
                patientId
            }
        },
        {
            model: 'AdministeredVaccine',
            values: {
                id: administeredVaccineId,
                date,
                reason,
                consent: [
                    'true',
                    'yes',
                    't',
                    'y'
                ].some((v)=>v === consent?.toLowerCase()),
                ...data,
                // relationships
                encounterId
            }
        }
    ];
}
function translatedStringLoader(item) {
    const { stringId, ...languages } = stripNotes(item);
    return Object.entries(languages).filter(([, text])=>text.trim()).map(([language, text])=>({
            model: 'TranslatedString',
            values: {
                stringId,
                language,
                text
            }
        }));
}
function patientDataLoader(item, models, foreignKeySchemata) {
    const { dateOfBirth, id: patientId, patientAdditionalData, ...otherFields } = item;
    const rows = [];
    rows.push({
        model: 'Patient',
        values: {
            id: patientId,
            dateOfBirth: dateOfBirth && (0, _exceldatetojs.getJsDateFromExcel)(dateOfBirth),
            ...otherFields
        }
    });
    if (patientAdditionalData?.toString().toUpperCase() === 'TRUE') {
        rows.push({
            model: 'PatientAdditionalData',
            values: {
                patientId,
                ...otherFields
            }
        });
    }
    const predefinedPatientFields = [
        ...Object.keys(models.Patient.rawAttributes) || [],
        ...Object.keys(models.PatientAdditionalData.rawAttributes) || []
    ];
    for (const definitionId of Object.keys(otherFields)){
        // Filter only custom fields that have a value assigned to them
        // Foreign keys will not appear as they are under rawAttributes (i.e: village -> villageId)
        if (predefinedPatientFields.includes(definitionId) || foreignKeySchemata.Patient.find((schema)=>schema.field === definitionId) || !otherFields[definitionId]) continue;
        rows.push({
            model: 'PatientFieldValue',
            values: {
                patientId,
                definitionId,
                value: otherFields[definitionId]
            }
        });
    }
    return rows;
}
function permissionLoader(item) {
    const { verb, noun, objectId = null, ...roles } = stripNotes(item);
    // Any non-empty value in the role cell would mean the role
    // is enabled for the permission
    return Object.entries(roles).map(([role, yCell])=>[
            role,
            yCell.toLowerCase().trim()
        ]).filter(([, yCell])=>yCell).map(([role, yCell])=>{
        const id = `${role}-${verb}-${noun}-${objectId || 'any'}`.toLowerCase();
        const isDeleted = yCell === 'n';
        const deletedAt = isDeleted ? new Date() : null;
        return {
            model: 'Permission',
            values: {
                _yCell: yCell,
                id,
                verb,
                noun,
                objectId,
                role,
                deletedAt
            }
        };
    });
}
function labTestPanelLoader(item) {
    const { id, testTypesInPanel, ...otherFields } = item;
    const rows = [];
    rows.push({
        model: 'LabTestPanel',
        values: {
            id,
            ...otherFields
        }
    });
    (testTypesInPanel || '').split(',').map((t)=>t.trim()).forEach((testType)=>{
        rows.push({
            model: 'LabTestPanelLabTestTypes',
            values: {
                id: `${id};${testType}`,
                labTestPanelId: id,
                labTestTypeId: testType
            }
        });
    });
    return rows;
}

//# sourceMappingURL=loaders.js.map