"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createApp", {
    enumerable: true,
    get: function() {
        return createApp;
    }
});
const _createApi = require("./createApi");
const _createWebsocket = require("./createWebsocket");
async function createApp(ctx) {
    const api = await (0, _createApi.createApi)(ctx);
    const websocket = await (0, _createWebsocket.createWebsocket)(api.httpServer, ctx);
    return {
        express: api.express,
        server: api.httpServer,
        websocket
    };
}

//# sourceMappingURL=createApp.js.map