"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createHandler", {
    enumerable: true,
    get: function() {
        return createHandler;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _fhir = require("@tamanu/shared/utils/fhir");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function mapErr(promise, fn) {
    try {
        return await promise;
    } catch (err) {
        throw fn(err);
    }
}
function createHandler(FhirResource) {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const { FhirJob } = req.store.models;
        const validated = await mapErr(FhirResource.INTAKE_SCHEMA.shape({
            resourceType: _yup.string().test('is-same-as-route', `must be '${FhirResource.fhirName}'`, (t)=>t === FhirResource.fhirName).required()
        }).validate(req.body, {
            stripUnknown: true
        }), (err)=>_fhir.OperationOutcome.fromYupError(err));
        const resource = new FhirResource(validated);
        const upstream = await resource.pushUpstream({
            requesterId: req.user?.id
        });
        if (FhirResource.CAN_DO.has(_constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE)) {
            FhirJob.submit(_constants.JOB_TOPICS.FHIR.REFRESH.FROM_UPSTREAM, {
                resource: FhirResource.fhirName,
                upstreamId: upstream.id
            });
        }
        // in spec, we should Location: to the resource, but we don't have it yet
        // TODO: generate ID here, and return it (if resource can be materialised)
        res.status(201).send();
    });
}

//# sourceMappingURL=create.js.map