"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "requireClientHeaders", {
    enumerable: true,
    get: function() {
        return requireClientHeaders;
    }
});
const _errors = require("@tamanu/shared/errors");
const requireClientHeaders = (req, res, next)=>{
    const client = req.header('X-Tamanu-Client');
    const version = req.header('X-Version');
    if (!client) {
        next(new _errors.InvalidClientHeadersError(`Must pass an X-Tamanu-Client header`));
        return;
    }
    if (!version) {
        next(new _errors.InvalidClientHeadersError(`Must pass an X-Version header`));
        return;
    }
    next();
};

//# sourceMappingURL=requireClientHeaders.js.map