"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MAX_CLIENT_VERSION: function() {
        return MAX_CLIENT_VERSION;
    },
    MIN_CLIENT_VERSION: function() {
        return MIN_CLIENT_VERSION;
    },
    SUPPORTED_CLIENT_VERSIONS: function() {
        return SUPPORTED_CLIENT_VERSIONS;
    },
    VERSION: function() {
        return VERSION;
    },
    versionCompatibility: function() {
        return versionCompatibility;
    }
});
const _fs = require("fs");
const _path = require("path");
const _url = require("url");
const _semver = require("semver");
const _utils = require("@tamanu/shared/utils");
const _errors = require("@tamanu/shared/errors");
const _constants = require("@tamanu/constants");
const pkgpath = (0, _path.join)((0, _path.dirname)((0, _url.fileURLToPath)(require("url").pathToFileURL(__filename).toString())), '../../package.json');
const pkgjson = JSON.parse((0, _fs.readFileSync)(pkgpath, 'utf8'));
const { major, minor } = (0, _semver.parse)(pkgjson.version);
const VERSION = pkgjson.version;
// In general, all versions in the current minor version should be compatible with each other.
// However, if there is an incompatibility between any (web, facility) client version and a
// central server version, this can be used to override the forbid clients below a certain version
// from connecting.
//
// To do so, set this to a string like '1.30.2'.
//
// THIS SHOULD BE RARE and only used in exceptional circumstances.
// When merging to main or other branches, this MUST be reset to null.
const MIN_CLIENT_OVERRIDE = null;
const MIN_CLIENT_VERSION = MIN_CLIENT_OVERRIDE ?? `${major}.${minor}.0`;
const MAX_CLIENT_VERSION = `${major}.${minor}.999`;
const SUPPORTED_CLIENT_VERSIONS = {
    [_constants.SERVER_TYPES.FACILITY]: {
        min: MIN_CLIENT_VERSION,
        max: MAX_CLIENT_VERSION
    },
    [_constants.SERVER_TYPES.WEBAPP]: {
        min: MIN_CLIENT_VERSION,
        max: MAX_CLIENT_VERSION
    },
    [_constants.SERVER_TYPES.MOBILE]: {
        min: MIN_CLIENT_VERSION,
        max: MAX_CLIENT_VERSION
    },
    'fiji-vps': {
        min: null,
        max: null
    },
    'fiji-vrs': {
        min: null,
        max: null
    },
    medici: {
        min: null,
        max: null
    },
    mSupply: {
        min: null,
        max: null
    },
    FHIR: {
        min: null,
        max: null
    }
};
const versionCompatibility = (req, res, next)=>{
    const clientType = req.header('X-Tamanu-Client');
    if (!clientType) {
        // a thirdparty tool (or internal test suite) is using the API; ignore version checking
        next();
        return;
    }
    const clientTypes = Object.keys(SUPPORTED_CLIENT_VERSIONS);
    if (!clientTypes.includes(clientType)) {
        next(new _errors.InvalidClientHeadersError(`The only supported X-Tamanu-Client values are ${clientTypes.join(', ')}`));
        return;
    }
    const clientInfo = SUPPORTED_CLIENT_VERSIONS[clientType];
    const { min, max } = clientInfo;
    const runCheck = (0, _utils.buildVersionCompatibilityCheck)(min, max);
    runCheck(req, res, next);
};

//# sourceMappingURL=versionCompatibility.js.map