"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insertSurveyResponse", {
    enumerable: true,
    get: function() {
        return insertSurveyResponse;
    }
});
const _datefns = require("date-fns");
const _dateTime = require("@tamanu/shared/utils/dateTime");
const _chance = require("../../../chance");
const insertSurveyResponse = async ({ SurveyResponse, SurveyResponseAnswer }, setupData, { encounterId, startTime })=>{
    const { survey } = setupData.programSurveyAndQuestions;
    const response = await SurveyResponse.create({
        encounterId,
        surveyId: survey.id,
        startTime: (0, _dateTime.toDateTimeString)(startTime),
        endTime: (0, _dateTime.toDateTimeString)((0, _datefns.addMinutes)(startTime, 10))
    });
    const readableAnswers = generateAnswers(setupData);
    for (const [readableName, answer] of Object.entries(readableAnswers)){
        const code = humanReadableQuestionsToCode[readableName];
        await SurveyResponseAnswer.create({
            responseId: response.id,
            name: code,
            body: answer,
            dataElementId: `pde-${code}`
        });
    }
    return response;
};
const humanReadableQuestionsToCode = {
    consent: 'FijCOVSamp2',
    contactNumber: 'FijCOVSamp11',
    subdivision: 'FijCOVSamp62',
    publicOrPrivate: 'FijCOVSamp53',
    publicHealthFacility: 'FijCOVSamp4',
    privateHealthFacility: 'FijCOVSamp54',
    ethnicity: 'FijCOVSamp10',
    address: 'FijCOVSamp12',
    isRDT: 'FijCOVSamp42',
    purpose: 'FijCOVSamp15',
    otherPurpose: 'FijCOVSamp18',
    isRecentAdmission: 'FijCOVSamp16',
    placeOfAdmission: 'FijCOVSamp20',
    admissionDischargeDate: 'FijCOVSamp22',
    medicalHistory: 'FijCOVSamp24',
    medicalProblems: 'FijCOVSamp23',
    medicalProblemsOther: 'FijCOVSamp25',
    isHealthcareWorker: 'FijCOVSamp26',
    isPregnant: 'FijCOVSamp32',
    hasSymptoms: 'FijCOVSamp34',
    dateOfFirstSymptom: 'FijCOVSamp35',
    listOfSymptoms: 'FijCOVSamp36',
    otherSymptoms: 'FijCOVSamp37',
    isVaccinated: 'FijCOVSamp38',
    firstDoseDate: 'FijCOVSamp39',
    secondDoseDate: 'FijCOVSamp40',
    isHighRisk: 'FijCOVSamp59',
    isContactHighRisk: 'FijCOVSamp60'
};
const generateAnswers = ({ villages, facilitiesDepartmentsAndLocations })=>{
    // screen 1
    const consent = 'Yes'; // if they don't consent then the form isn't filled in
    const contactNumber = _chance.chance.integer({
        min: 1000000,
        max: 9999999
    }); // yes, in this survey it's a number
    const subdivision = _chance.chance.pickone(villages).id;
    const [facility] = _chance.chance.pickone(facilitiesDepartmentsAndLocations);
    const publicOrPrivate = _chance.chance.pickone([
        'Public',
        'Private'
    ]);
    let publicHealthFacility;
    let privateHealthFacility;
    if (publicOrPrivate === 'Public') {
        publicHealthFacility = facility.id; // TODO: actual survey uses ReferenceData
    } else {
        privateHealthFacility = `${_chance.chance.city()} ${_chance.chance.pickone([
            'Hospital',
            'Clinic',
            'Medical Center'
        ])}`;
    }
    const address = `${_chance.chance.address()} ${_chance.chance.city()}`;
    // screen 2
    const isRDT = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    const purpose = _chance.chance.pickone([
        'Symptoms',
        'Contact tracing',
        'High risk group screening',
        'Screening for hospital admission',
        'Pre-departure travel',
        'Border quarantine traveller',
        'Other'
    ]);
    let otherPurpose;
    if (purpose === 'Other') {
        otherPurpose = _chance.chance.sentence();
    }
    const isHealthcareWorker = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    const isPregnant = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    // screen 3
    const hasSymptoms = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    let dateOfFirstSymptom;
    let listOfSymptoms;
    let otherSymptoms;
    if (hasSymptoms) {
        dateOfFirstSymptom = _chance.chance.date({
            year: _chance.chance.pickone([
                2021,
                2022
            ])
        }).toISOString();
        const possibleSymptoms = [
            'Cough',
            'Runny nose/Nasal congestion/Sneezing',
            'Fever',
            'Sore throat',
            'Headache',
            'Body ache',
            'Loss of taste',
            'Loss of smell',
            'Shortness of breath',
            'Chest pain/heaviness',
            'Other'
        ];
        listOfSymptoms = _chance.chance.pickset(possibleSymptoms, _chance.chance.integer({
            min: 1,
            max: possibleSymptoms.length
        }));
        if (listOfSymptoms.includes('Other')) {
            otherSymptoms = _chance.chance.sentence();
        }
    }
    const isHighRisk = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    const isContactHighRisk = _chance.chance.pickone([
        'Yes',
        'No'
    ]);
    return {
        // screen 1
        consent,
        contactNumber,
        subdivision,
        publicOrPrivate,
        publicHealthFacility,
        privateHealthFacility,
        address,
        // screen 2
        isRDT,
        purpose,
        otherPurpose,
        isHealthcareWorker,
        isPregnant,
        // screen 3
        hasSymptoms,
        dateOfFirstSymptom,
        listOfSymptoms: listOfSymptoms.join(', '),
        otherSymptoms,
        isHighRisk,
        isContactHighRisk
    };
};

//# sourceMappingURL=insertSurveyResponse.js.map