"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createMarkedForSyncPatientsTable", {
    enumerable: true,
    get: function() {
        return createMarkedForSyncPatientsTable;
    }
});
const _sync = require("@tamanu/shared/sync");
const createMarkedForSyncPatientsTable = async (sequelize, sessionId, isFullSync, facilityId, since)=>{
    const tableName = (0, _sync.getMarkedForSyncPatientsTableName)(sessionId, isFullSync);
    await sequelize.query(`
    CREATE TABLE ${tableName} AS
    SELECT patient_id
    FROM patient_facilities
    WHERE facility_id = :facilityId
    ${isFullSync ? 'AND updated_at_sync_tick > :since' // get all the NEW marked for sync patients if it is FULL sync
     : 'AND updated_at_sync_tick <= :since' // get all the EXISTING marked for sync patients if it is regular sync
    }
  `, {
        replacements: {
            facilityId,
            since
        },
        type: sequelize.QueryTypes.SELECT
    });
    return tableName;
};

//# sourceMappingURL=createMarkedForSyncPatientsTable.js.map