"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MARITAL_STATUS_OPTIONS: function() {
        return MARITAL_STATUS_OPTIONS;
    },
    MARTIAL_STATUS_LABELS: function() {
        return MARTIAL_STATUS_LABELS;
    },
    MARTIAL_STATUS_VALUES: function() {
        return MARTIAL_STATUS_VALUES;
    },
    PATIENT_FIELD_DEFINITION_TYPES: function() {
        return PATIENT_FIELD_DEFINITION_TYPES;
    },
    PATIENT_FIELD_DEFINITION_TYPE_VALUES: function() {
        return PATIENT_FIELD_DEFINITION_TYPE_VALUES;
    },
    SEX_LABELS: function() {
        return SEX_LABELS;
    },
    SEX_OPTIONS: function() {
        return SEX_OPTIONS;
    },
    SEX_VALUES: function() {
        return SEX_VALUES;
    },
    SEX_VALUE_INDEX: function() {
        return SEX_VALUE_INDEX;
    }
});
const PATIENT_FIELD_DEFINITION_TYPES = {
    STRING: 'string',
    NUMBER: 'number',
    SELECT: 'select'
};
const PATIENT_FIELD_DEFINITION_TYPE_VALUES = Object.values(PATIENT_FIELD_DEFINITION_TYPES);
const MARTIAL_STATUS_VALUES = {
    DEFACTO: 'Defacto',
    MARRIED: 'Married',
    SINGLE: 'Single',
    WIDOW: 'Widow',
    DIVORCED: 'Divorced',
    SEPARATED: 'Separated',
    UNKNOWN: 'Unknown'
};
const SEX_VALUES = {
    MALE: 'male',
    FEMALE: 'female',
    OTHER: 'other'
};
const MARTIAL_STATUS_LABELS = {
    [MARTIAL_STATUS_VALUES.DEFACTO]: 'De facto',
    [MARTIAL_STATUS_VALUES.MARRIED]: 'Married',
    [MARTIAL_STATUS_VALUES.SINGLE]: 'Single',
    [MARTIAL_STATUS_VALUES.WIDOW]: 'Widow',
    [MARTIAL_STATUS_VALUES.DIVORCED]: 'Divorced',
    [MARTIAL_STATUS_VALUES.SEPARATED]: 'Separated',
    [MARTIAL_STATUS_VALUES.UNKNOWN]: 'Unknown'
};
const MARITAL_STATUS_OPTIONS = [
    {
        value: MARTIAL_STATUS_VALUES.DEFACTO,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.DEFACTO]
    },
    {
        value: MARTIAL_STATUS_VALUES.MARRIED,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.MARRIED]
    },
    {
        value: MARTIAL_STATUS_VALUES.SINGLE,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.SINGLE]
    },
    {
        value: MARTIAL_STATUS_VALUES.WIDOW,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.WIDOW]
    },
    {
        value: MARTIAL_STATUS_VALUES.DIVORCED,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.DIVORCED]
    },
    {
        value: MARTIAL_STATUS_VALUES.SEPARATED,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.SEPARATED]
    },
    {
        value: MARTIAL_STATUS_VALUES.UNKNOWN,
        label: MARTIAL_STATUS_LABELS[MARTIAL_STATUS_VALUES.UNKNOWN]
    }
];
const SEX_LABELS = {
    [SEX_VALUES.MALE]: 'Male',
    [SEX_VALUES.FEMALE]: 'Female',
    [SEX_VALUES.OTHER]: 'Other'
};
const SEX_OPTIONS = [
    {
        value: SEX_VALUES.MALE,
        label: SEX_LABELS[SEX_VALUES.MALE]
    },
    {
        value: SEX_VALUES.FEMALE,
        label: SEX_LABELS[SEX_VALUES.FEMALE]
    },
    {
        value: SEX_VALUES.OTHER,
        label: SEX_LABELS[SEX_VALUES.OTHER]
    }
];
const SEX_VALUE_INDEX = SEX_OPTIONS.reduce((dict, option)=>({
        ...dict,
        [option.value]: option
    }), {});

//# sourceMappingURL=patientFields.js.map