"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "seedSettings", {
    enumerable: true,
    get: function() {
        return seedSettings;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _settings = require("@tamanu/settings");
const _lodash = require("lodash");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const seedForScope = async (models, settings, serverFacilityId, scopeOverride)=>{
    const { Setting } = models;
    const getScope = ()=>{
        if (scopeOverride) return scopeOverride;
        return serverFacilityId ? _constants.SETTINGS_SCOPES.FACILITY : _constants.SETTINGS_SCOPES.GLOBAL;
    };
    const scope = getScope();
    const existing = await Setting.get('', serverFacilityId, scope);
    const combined = (0, _lodash.defaultsDeep)(existing, settings);
    return Setting.set('', combined, scope, serverFacilityId);
};
async function seedSettings(models) {
    const { serverFacilityId } = _config.default;
    await seedForScope(models, _settings.globalTestSettings);
    if (serverFacilityId) {
        await seedForScope(models, _settings.facilityTestSettings, serverFacilityId);
    } else {
        await seedForScope(models, _settings.centralTestSettings, null, _constants.SETTINGS_SCOPES.CENTRAL);
    }
}

//# sourceMappingURL=settings.js.map