"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('lab_test_panel_lab_test_types', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        lab_test_panel_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'lab_test_panels',
                key: 'id'
            }
        },
        lab_test_type_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'lab_test_types',
                key: 'id'
            }
        }
    });
}
async function down(query) {
    await query.dropTable('lab_test_panel_lab_test_types');
}

//# sourceMappingURL=167662077668-AddLabTestPanelLabTestTypesTable.js.map