"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterHistory", {
    enumerable: true,
    get: function() {
        return EncounterHistory;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let EncounterHistory = class EncounterHistory extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            encounterType: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            changeType: {
                type: _sequelize.Sequelize.STRING
            },
            date: (0, _dateTimeTypes.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            })
        }, {
            ...options,
            tableName: 'encounter_history',
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.User, {
            foreignKey: 'examinerId',
            as: 'examiner'
        });
        this.belongsTo(models.Location, {
            foreignKey: 'locationId',
            as: 'location'
        });
        this.belongsTo(models.Department, {
            foreignKey: 'departmentId',
            as: 'department'
        });
        this.belongsTo(models.User, {
            foreignKey: 'actorId',
            as: 'actor'
        });
    }
    static async createSnapshot(encounter, { actorId, changeType, submittedTime }, options = {}) {
        return EncounterHistory.create({
            encounterId: encounter.id,
            encounterType: encounter.encounterType,
            locationId: encounter.locationId,
            departmentId: encounter.departmentId,
            examinerId: encounter.examinerId,
            actorId,
            changeType,
            date: submittedTime || (0, _dateTime.getCurrentDateTimeString)()
        }, options);
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=EncounterHistory.js.map