"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceItemDiscount", {
    enumerable: true,
    get: function() {
        return InvoiceItemDiscount;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let InvoiceItemDiscount = class InvoiceItemDiscount extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            percentage: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: false
            },
            reason: _sequelize.DataTypes.STRING
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    /**
   *
   * @param {import('./')} models
   */ static initRelations(models) {
        this.belongsTo(models.InvoiceItem, {
            foreignKey: 'invoiceItemId',
            as: 'invoiceItem'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoice_items',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoice_items',
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoiceItemDiscount.js.map