"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "OneTimeLogin", {
    enumerable: true,
    get: function() {
        return OneTimeLogin;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let OneTimeLogin = class OneTimeLogin extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            token: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            expiresAt: {
                type: _sequelize.Sequelize.DATE,
                allowNull: false
            },
            usedAt: {
                type: _sequelize.Sequelize.DATE,
                allowNull: true
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.DO_NOT_SYNC,
            ...options
        });
    }
    isExpired() {
        return this.expiresAt < new Date();
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: {
                name: 'userId',
                allowNull: false
            },
            as: 'user'
        });
    }
};

//# sourceMappingURL=OneTimeLogin.js.map