"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchParameters", {
    enumerable: true,
    get: function() {
        return searchParameters;
    }
});
const _constants = require("@tamanu/constants");
const searchParameters = {
    identifier: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'identifier',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE
    },
    given: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'name',
                '[]',
                'given',
                '[]'
            ]
        ]
    },
    family: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'name',
                '[]',
                'family'
            ]
        ]
    },
    gender: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'gender'
            ]
        ],
        sortable: false,
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.STRING
    },
    birthdate: {
        type: _constants.FHIR_SEARCH_PARAMETERS.DATE,
        path: [
            [
                'birthDate'
            ]
        ],
        datePrecision: _constants.FHIR_DATETIME_PRECISION.DAYS
    },
    address: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'address',
                '[]',
                'line',
                '[]'
            ],
            [
                'address',
                '[]',
                'city'
            ],
            [
                'address',
                '[]',
                'district'
            ],
            [
                'address',
                '[]',
                'state'
            ],
            [
                'address',
                '[]',
                'country'
            ],
            [
                'address',
                '[]',
                'postal_code'
            ],
            [
                'address',
                '[]',
                'text'
            ]
        ]
    },
    'address-city': {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'address',
                '[]',
                'city'
            ]
        ]
    },
    telecom: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'telecom',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE
    },
    deceased: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'deceasedDateTime'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.PRESENCE
    },
    active: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'active'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.BOOLEAN
    },
    link: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'link',
                '[]',
                'other'
            ]
        ],
        referenceTypes: [
            'Patient'
        ]
    }
};

//# sourceMappingURL=searchParameters.js.map