"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientDetailsSection", {
    enumerable: true,
    get: function() {
        return PatientDetailsSection;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _Layout = require("./Layout");
const _Typography = require("./Typography");
const _patientAccessors = require("../patientAccessors");
const _languageContext = require("../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientFields = (getTranslation)=>[
        {
            key: 'firstName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.firstName', 'First Name')
        },
        {
            key: 'displayId',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.patientId', 'Patient ID')
        },
        {
            key: 'lastName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.lastName', 'Last Name')
        },
        {
            key: 'sex',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.sex', 'Sex'),
            accessor: _patientAccessors.getSex
        },
        {
            key: 'dateOfBirth',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.dob', 'DOB'),
            accessor: _patientAccessors.getDOB
        },
        {
            key: 'villageName',
            label: getTranslation('pdf.vaccineCertificate.patientDetails.village', 'Village'),
            accessor: _patientAccessors.getVillageName
        }
    ];
const PatientDetailsSection = ({ patient, getLocalisation, extraFields = [] })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const detailsToDisplay = [
        ...patientFields(getTranslation),
        ...extraFields
    ].filter(({ key })=>!getLocalisation(`fields.${key}.hidden`));
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_Typography.H3, {
        style: {
            marginBottom: 0
        }
    }, getTranslation('pdf.vaccineCertificate.patientDetails.title', 'Patient Details')), /*#__PURE__*/ _react.default.createElement(_Layout.LightDivider, null), /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
        style: {
            marginBottom: 5
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(patient, getLocalisation) : patient[key]) || '';
        const label = getLocalisation(`fields.${key}.shortLabel`) || defaultLabel;
        return /*#__PURE__*/ _react.default.createElement(_Layout.Col, {
            style: {
                width: '50%'
            },
            key: key
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            mb: 6,
            fontSize: 9
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            bold: true,
            fontSize: 9
        }, label, ":"), ' ', value));
    })))), /*#__PURE__*/ _react.default.createElement(_Layout.LightDivider, null));
};

//# sourceMappingURL=PatientDetailsSection.js.map