const Sequelize = require('sequelize');
module.exports = {
    up: async (query)=>{
        await query.createTable('invoice_line_types', {
            id: {
                type: Sequelize.STRING,
                defaultValue: Sequelize.UUIDV4,
                allowNull: false,
                primaryKey: true
            },
            item_id: {
                type: Sequelize.STRING,
                allowNull: false
            },
            item_type: {
                type: Sequelize.STRING,
                allowNull: false
            },
            name: {
                type: Sequelize.TEXT,
                allowNull: false
            },
            price: {
                type: Sequelize.DECIMAL,
                allowNull: false
            },
            created_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            updated_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            },
            deleted_at: {
                type: Sequelize.DATE,
                defaultValue: Sequelize.NOW
            }
        });
    },
    down: async (query)=>{
        await query.dropTable('invoice_line_types');
    }
};

//# sourceMappingURL=048_invoice_1_addInvoiceLineTypeTable.js.map