import React from 'react';
import { Col, Row, VDSImage } from './Layout';
import { P } from './Typography';
import { getDOB, getNationality, getPassportNumber } from '../patientAccessors';
const PATIENT_FIELDS = [
    {
        key: 'firstName',
        label: 'First name'
    },
    {
        key: 'lastName',
        label: 'Last name'
    },
    {
        key: 'dateOfBirth',
        label: 'Date of birth',
        accessor: getDOB
    },
    {
        key: 'sex',
        label: 'Sex'
    },
    {
        key: 'displayId',
        label: 'NHN'
    },
    {
        key: 'passport',
        label: 'Passport number',
        accessor: getPassportNumber
    },
    {
        key: 'nationality',
        label: 'Nationality',
        accessor: getNationality
    }
];
export const CovidPatientDetailsSection = ({ patient, getLocalisation, vdsSrc, extraFields = [], uvci })=>{
    const detailsToDisplay = [
        ...PATIENT_FIELDS,
        ...extraFields
    ].filter(({ key })=>!getLocalisation(`fields.${key}.hidden`));
    const leftWidth = vdsSrc ? 68 : 80;
    const rightWidth = 100 - leftWidth;
    return /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: `${leftWidth}%`
        }
    }, /*#__PURE__*/ React.createElement(Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(patient, getLocalisation) : patient[key]) || '';
        const label = getLocalisation(`fields.${key}.shortLabel`) || defaultLabel;
        return /*#__PURE__*/ React.createElement(Col, {
            key: key
        }, /*#__PURE__*/ React.createElement(P, {
            mb: 5
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true
        }, label, ":"), " ", value));
    })), uvci && /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, null, /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, "UVCI:"), " ", uvci))), /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: `${rightWidth}%`
        }
    }, vdsSrc && /*#__PURE__*/ React.createElement(VDSImage, {
        src: vdsSrc
    })));
};

//# sourceMappingURL=CovidPatientDetailsSection.js.map